/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public class CommandInjectionChecker {
    public static boolean isExistsCommandInjection(String command) {
        Pattern cmdInjPattern;
        String pattern = "[|;$&><`!\\\\]+";
        if (CommandInjectionChecker.containsCheck(System.getProperty("os.name"), "windows")) {
            pattern = "[|;$&><`!]+";
        }
        return (cmdInjPattern = Pattern.compile(pattern)).matcher(command).find();
    }

    private static boolean containsCheck(String var1, String var2) {
        String tempVar1 = CommandInjectionChecker.canonicalizeString(var1);
        String tempVar2 = CommandInjectionChecker.canonicalizeString(var2);
        return CommandInjectionChecker.toLower(tempVar1).contains(CommandInjectionChecker.toLower(tempVar2));
    }

    private static String canonicalizeString(String strVal) {
        return strVal != null ? Normalizer.normalize(strVal, Normalizer.Form.NFKC) : null;
    }

    private static String toLower(String input) {
        String inputString = null;
        inputString = input != null ? input.toLowerCase(Locale.ROOT) : "";
        return inputString;
    }
}

