/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.util.SetFilePermission;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class MigrationFileAttributes
implements FileAttribute<List<AclEntry>> {
    private Set<AclEntryPermission> userChosenPermissions;

    public MigrationFileAttributes(Set<AclEntryPermission> userChosenPermissions) {
        this.userChosenPermissions = userChosenPermissions;
    }

    @Override
    public List<AclEntry> value() {
        FileSystem fileSystem = null;
        UserPrincipal userPrincipal = null;
        try {
            fileSystem = FileSystems.getDefault();
            UserPrincipalLookupService userPrincipalLookupService = fileSystem.getUserPrincipalLookupService();
            userPrincipal = userPrincipalLookupService.lookupPrincipalByName(System.getProperty("user.name"));
        }
        catch (IOException e) {
            throw new FileException("IOException thrown while setting user name");
        }
        finally {
            try {
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (Exception exception) {}
        }
        EnumSet<AclEntryFlag> flags = EnumSet.of(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT);
        AclEntry.Builder builder = AclEntry.newBuilder();
        builder.setFlags(flags);
        if (this.userChosenPermissions != null && this.userChosenPermissions.size() > 0) {
            builder.setPermissions(this.userChosenPermissions);
        } else {
            builder.setPermissions(SetFilePermission.windowsPermissions);
        }
        builder.setPrincipal(userPrincipal);
        builder.setType(AclEntryType.ALLOW);
        AclEntry entry = builder.build();
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>(1);
        aclEntryList.add(entry);
        return aclEntryList;
    }

    @Override
    public String name() {
        return "acl:acl";
    }
}

