/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.interfaces.ISetFilePermission;
import com.huawei.db.migration.util.MigrationFileAttributes;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public class SetFilePermission
implements ISetFilePermission {
    static Set<AclEntryPermission> windowsPermissions = EnumSet.of(AclEntryPermission.DELETE, new AclEntryPermission[]{AclEntryPermission.DELETE_CHILD, AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.APPEND_DATA, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_ACL});
    private static final int SIMLINK_DEPTH = 5;
    Set<PosixFilePermission> LINUX_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    Set<PosixFilePermission> LINUX_PERMISSIONS_FOL = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private final String osName = this.toLower(System.getProperty("os.name"));

    @Override
    public boolean createFileWithPermissionInWin(String path) throws FileException {
        if (!this.isInSecureDir(Paths.get(path, new String[0]))) {
            Set<AclEntryPermission> userChosenPermissions = windowsPermissions;
            Path newPath = Paths.get(path, new String[0]);
            if (newPath != null) {
                boolean fileExists = Files.exists(newPath, new LinkOption[0]);
                MigrationFileAttributes fileAttributes = new MigrationFileAttributes(userChosenPermissions);
                try {
                    if (!fileExists) {
                        Files.createFile(newPath, fileAttributes);
                        if (!newPath.toFile().setExecutable(false)) {
                            return true;
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileException("IOException: Setting file permission/Creating file  " + path + " failed in Windows env");
                }
            }
            return newPath != null;
        }
        return false;
    }

    @Override
    public boolean createFolderWithPermissionInWin(String path, boolean isLog) throws FileException {
        Set<AclEntryPermission> userChosenPermissions = windowsPermissions;
        if (!this.isInSecureDir(Paths.get(path, new String[0]))) {
            Path newPath = Paths.get(path, new String[0]);
            userChosenPermissions.add(AclEntryPermission.EXECUTE);
            MigrationFileAttributes fileAttributes = new MigrationFileAttributes(userChosenPermissions);
            try {
                if (!isLog) {
                    if (!newPath.toFile().isDirectory()) {
                        Files.createDirectory(newPath, fileAttributes);
                    }
                } else {
                    this.changeFileOrFolPermissionsWin(newPath, userChosenPermissions);
                }
            }
            catch (IOException e) {
                throw new FileException("IOException: Creating folder with permission at " + path + " failed in Windows env");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean createFileWithPermissionInLinux(String path) throws FileException {
        if (!this.isInSecureDir(Paths.get(path, new String[0]))) {
            Set<PosixFilePermission> userChosenPermissions = this.LINUX_PERMISSIONS;
            Path newPath = Paths.get(path, new String[0]);
            boolean isCreated = false;
            if (newPath != null) {
                boolean fileExists = Files.exists(newPath, new LinkOption[0]);
                try {
                    if (!fileExists) {
                        isCreated = newPath.toFile().createNewFile();
                        Files.setPosixFilePermissions(newPath, userChosenPermissions);
                        if (!newPath.toFile().setExecutable(false)) {
                            throw new FileException("Unable to disable the execution permission for the file.");
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileException("IOException: Setting file permission/Creating file  " + path + " failed in Linux env ");
                }
            }
            return isCreated;
        }
        return false;
    }

    @Override
    public boolean createFolderWithPermissionInLinux(String path, boolean isLog) throws FileException {
        if (!this.isInSecureDir(Paths.get(path, new String[0]))) {
            Path newPath = Paths.get(path, new String[0]);
            Set<PosixFilePermission> userFolPermissions = this.LINUX_PERMISSIONS_FOL;
            boolean isCreated = false;
            try {
                if (!isLog) {
                    if (!newPath.toFile().isDirectory()) {
                        isCreated = newPath.toFile().mkdirs();
                        Files.setPosixFilePermissions(newPath, userFolPermissions);
                    }
                } else {
                    Files.setPosixFilePermissions(newPath, userFolPermissions);
                }
            }
            catch (IOException e) {
                throw new FileException("IOException: Creating folder with permissions at  " + path + " failed in Linux env ");
            }
            return isCreated;
        }
        return false;
    }

    @Override
    public boolean changeFilePermissionInWin(String path) throws FileException {
        Set<AclEntryPermission> userChosenPermissions = windowsPermissions;
        Path newPath = Paths.get(path, new String[0]);
        try {
            File[] listOfFiles = newPath.toFile().listFiles();
            if (listOfFiles != null) {
                for (File logFiles : listOfFiles) {
                    this.changeFileOrFolPermissionsWin(logFiles.toPath(), userChosenPermissions);
                    if (logFiles.setExecutable(false)) continue;
                }
            }
        }
        catch (FileException e) {
            throw new FileException("FileException: Setting/Changing file permission " + path + " failed in Windows ");
        }
        return true;
    }

    @Override
    public boolean changeFilePermissionInLinux(String path) throws FileException {
        Set<PosixFilePermission> userChosenPermissions = this.LINUX_PERMISSIONS;
        Path newPath = Paths.get(path, new String[0]);
        if (newPath != null) {
            File[] listOfFiles = newPath.toFile().listFiles();
            try {
                if (listOfFiles != null) {
                    for (File files : listOfFiles) {
                        if (!files.exists()) continue;
                        Files.setPosixFilePermissions(files.toPath(), userChosenPermissions);
                        if (files.setExecutable(false)) continue;
                        throw new FileException("Unable to disable the execution permission for the files.");
                    }
                }
            }
            catch (IOException e) {
                throw new FileException("IOException: Setting file permission/Creating file  " + path + " failed in Linux env ");
            }
        }
        return true;
    }

    private boolean changeFileOrFolPermissionsWin(Path logFile, Set<AclEntryPermission> userChosenPermissions) throws FileException {
        UserPrincipalLookupService upls = logFile.getFileSystem().getUserPrincipalLookupService();
        try {
            UserPrincipal user = upls.lookupPrincipalByName(System.getProperty("user.name"));
            AclEntry.Builder builder = AclEntry.newBuilder();
            builder.setPermissions(userChosenPermissions);
            builder.setPrincipal(user);
            builder.setType(AclEntryType.ALLOW);
            AclFileAttributeView aclAttr = Files.getFileAttributeView(logFile, AclFileAttributeView.class, new LinkOption[0]);
            aclAttr.setAcl(Collections.singletonList(builder.build()));
        }
        catch (IOException e) {
            throw new FileException("IOException: Setting/Changing file/folder permissions failed in Windows env ");
        }
        return true;
    }

    public boolean isInSecureDir(Path file) {
        return this.isInSecureDir(file, null);
    }

    private boolean isInSecureDir(Path file, UserPrincipal userName) {
        return this.isInSecureDir(file, userName, 5);
    }

    private boolean isInSecureDir(Path fileIn, UserPrincipal userNameIn, int symlinkDepth) {
        UserPrincipal root;
        Path file = fileIn;
        UserPrincipal userName = userNameIn;
        if (file == null) {
            return false;
        }
        try {
            file = this.getFileAbsPath(file);
        }
        catch (SecurityException s) {
            return false;
        }
        if (symlinkDepth <= 0 || file == null) {
            return false;
        }
        UserPrincipal[] result = this.parseFilePath(null, file, userName);
        userName = result.length > 0 ? result[0] : null;
        UserPrincipal userPrincipal = root = result.length > 1 ? result[1] : null;
        if (userName == null && root == null) {
            return false;
        }
        return this.parseParentPath(root, file, userName, symlinkDepth);
    }

    private Path getFileAbsPath(Path file) {
        if (!file.isAbsolute()) {
            return file.toAbsolutePath();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPrincipal[] parseFilePath(UserPrincipal rootIn, Path file, UserPrincipal userNameIn) {
        UserPrincipal userName;
        UserPrincipal root;
        block23: {
            UserPrincipal[] userPrincipalArray;
            root = rootIn;
            userName = userNameIn;
            FileSystem fileSystem = null;
            try {
                UserPrincipalLookupService upls;
                Path path = file.getRoot();
                if (path == null) break block23;
                fileSystem = Paths.get(path.toString(), new String[0]).getFileSystem();
                if (fileSystem != null && (upls = fileSystem.getUserPrincipalLookupService()) != null) {
                    root = !this.osName.contains("win") ? upls.lookupPrincipalByName("root") : upls.lookupPrincipalByName("Administrators");
                    if (userName == null) {
                        userName = upls.lookupPrincipalByName(System.getProperty("user.name"));
                        UserPrincipal[] userPrincipalArray2 = new UserPrincipal[]{userName, root};
                        return userPrincipalArray2;
                    }
                }
                if (root != null && userName != null) break block23;
                userPrincipalArray = new UserPrincipal[]{null, null};
            }
            catch (UnsupportedOperationException a) {
                userPrincipalArray = new UserPrincipal[]{null, null};
                return userPrincipalArray;
            }
            catch (IOException x) {
                userPrincipalArray = new UserPrincipal[]{null, null};
                return userPrincipalArray;
            }
            finally {
                try {
                    if (fileSystem != null) {
                        fileSystem.close();
                    }
                }
                catch (Exception exception) {}
            }
            return userPrincipalArray;
        }
        return new UserPrincipal[]{userName, root};
    }

    private boolean parseParentPath(UserPrincipal root, Path file, UserPrincipal userName, int symlinkDepth) {
        Path partialPath = Paths.get(file.toString(), new String[0]);
        try {
            if (Files.isSymbolicLink(partialPath)) {
                if (this.isInSecureDir(Files.readSymbolicLink(partialPath), userName, symlinkDepth - 1)) {
                    return false;
                }
            } else {
                PosixFileAttributes attr;
                Set<PosixFilePermission> perms;
                UserPrincipal owner = Files.getOwner(partialPath, new LinkOption[0]);
                if (userName != null && !userName.equals(owner) && root != null && !root.equals(owner)) {
                    return false;
                }
                if (!this.osName.contains("win") && (perms = (attr = Files.readAttributes(partialPath, PosixFileAttributes.class, new LinkOption[0])).permissions()) != null && (perms.contains((Object)PosixFilePermission.GROUP_WRITE) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE))) {
                    return false;
                }
            }
        }
        catch (IOException x) {
            return false;
        }
        return true;
    }

    private String toLower(String input) {
        String inputString = input;
        if (input != null) {
            inputString = input.toLowerCase(Locale.ROOT);
        }
        return inputString;
    }
}

