/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.config.PartitionKeyChooseStrategy;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSPartitionKeyChooserStrategy
implements PartitionKeyChooseStrategy {
    private static final Logger LOGGER = LogManager.getLogger(DWSPartitionKeyChooserStrategy.class);
    private static Set<SqlTypeName> supportDistributedColumns = new HashSet<SqlTypeName>();

    @Override
    public List<SqlColumnDefinition> choosePartitionKey(SqlCreateTable table, ConvertConfig config) {
        List<SqlColumnDefinition> columns = this.getPartitionColumnsFromConfig(table, config);
        if (columns != null && !columns.isEmpty()) {
            return columns;
        }
        columns = this.getPartitionColumnsFromPrimary(table);
        if (!columns.isEmpty()) {
            return columns;
        }
        columns = this.getPartitionColumnsFromUnique(table);
        if (!columns.isEmpty()) {
            return columns;
        }
        return this.getDefaultPartitionColumn(table);
    }

    @Override
    public SqlCreateTable chooseDistributeKeyContainsConstraint(SqlCreateTable table, ConvertConfig config) {
        SqlCreateTable sqlCreateTable = new SqlCreateTable();
        List<SqlColumnDefinition> columns = this.getPartitionColumnsFromConfig(table, config);
        if (columns != null && !columns.isEmpty()) {
            sqlCreateTable.setColumns(columns);
            return sqlCreateTable;
        }
        columns = this.getPartitionColumnsFromPrimary(table);
        if (!columns.isEmpty()) {
            columns = this.removeUnSupportColumns(columns);
            sqlCreateTable.setColumns(columns);
            return sqlCreateTable;
        }
        List<SqlTableConstraint> constraintsFromUnique = this.getConstraintsFromUnique(table);
        if (!constraintsFromUnique.isEmpty()) {
            constraintsFromUnique = this.removeUnSupportConstraintColumns(constraintsFromUnique);
            sqlCreateTable.setConstraints(constraintsFromUnique);
            return sqlCreateTable;
        }
        columns = this.getPartitionColumnsFromUnique(table);
        if (!columns.isEmpty()) {
            columns = this.removeUnSupportColumns(columns);
            sqlCreateTable.setColumns(columns);
            return sqlCreateTable;
        }
        columns = this.getDefaultPartitionColumn(table);
        sqlCreateTable.setColumns(columns);
        return sqlCreateTable;
    }

    private List<SqlColumnDefinition> getPartitionColumnsFromUnique(SqlCreateTable table) {
        List<SqlCreateIndex> indexs = table.getIndexs();
        for (SqlCreateIndex index : indexs) {
            if (index.getSpecialType() != SqlCreateIndex.SpecialType.UNIQUE) continue;
            return this.convertIndexColumns(table, index);
        }
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        for (SqlColumnDefinition col : table.getColumns()) {
            if (!col.isUniquekey()) continue;
            res.add(col);
        }
        return res;
    }

    private List<SqlColumnDefinition> getPartitionColumnsFromPrimary(SqlCreateTable table) {
        List<SqlCreateIndex> indexs = table.getIndexs();
        for (SqlCreateIndex index : indexs) {
            if (index.getSpecialType() != SqlCreateIndex.SpecialType.PRIMARY) continue;
            return this.convertIndexColumns(table, index);
        }
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        for (SqlColumnDefinition col : table.getColumns()) {
            if (!col.isPrimaryKey()) continue;
            res.add(col);
        }
        return res;
    }

    private List<SqlColumnDefinition> convertIndexColumns(SqlCreateTable table, SqlCreateIndex index) {
        SqlNodeList<SqlIndexColumnName> primaryColumns = index.getIndexColumns();
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        block0: for (SqlColumnDefinition col : table.getColumns()) {
            String columnName = col.getColumnName().getIdentifier();
            for (SqlIndexColumnName ic : primaryColumns.getNodes()) {
                if (!columnName.equalsIgnoreCase(ic.getColumnName().getIdentifier())) continue;
                res.add(col);
                continue block0;
            }
        }
        return res;
    }

    private List<SqlColumnDefinition> getPartitionColumnsFromConfig(SqlCreateTable table, ConvertConfig config) {
        String names = ConfigUtil.getConfigValue(config, "table.partition-key.name", null);
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        String[] cols = names.split(",");
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        block0: for (SqlColumnDefinition col : table.getColumns()) {
            String columnName = col.getColumnName().getIdentifier();
            for (String c : cols) {
                if (!columnName.equalsIgnoreCase(c)) continue;
                res.add(col);
                continue block0;
            }
        }
        return res;
    }

    private List<SqlColumnDefinition> getDefaultPartitionColumn(SqlCreateTable table) {
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        for (SqlColumnDefinition c : table.getColumns()) {
            if (!supportDistributedColumns.contains((Object)c.getDataType().getTypeName())) continue;
            res.add(c);
            return res;
        }
        return null;
    }

    private List<SqlTableConstraint> getConstraintsFromUnique(SqlCreateTable table) {
        ArrayList<SqlTableConstraint> list = new ArrayList<SqlTableConstraint>();
        List<SqlTableConstraint> constraints = table.getConstraints();
        if (constraints != null && !constraints.isEmpty()) {
            for (SqlTableConstraint sqlTableConstraint : constraints) {
                if (!(sqlTableConstraint instanceof SqlUKeyTableConstraint)) continue;
                list.add(sqlTableConstraint);
            }
        }
        return list;
    }

    private List<SqlColumnDefinition> removeUnSupportColumns(List<SqlColumnDefinition> columns) {
        ArrayList<SqlColumnDefinition> sqlColumnDefinitions = new ArrayList<SqlColumnDefinition>();
        for (SqlColumnDefinition sqlColumnDefinition : columns) {
            if (!supportDistributedColumns.contains((Object)sqlColumnDefinition.getDataType().getTypeName())) continue;
            sqlColumnDefinitions.add(sqlColumnDefinition);
        }
        if (sqlColumnDefinitions.isEmpty()) {
            LOGGER.error("Can not found distributed columns!");
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Can not found distributed columns! Syntax : distributed columns data type");
        }
        return sqlColumnDefinitions;
    }

    private List<SqlTableConstraint> removeUnSupportConstraintColumns(List<SqlTableConstraint> columns) {
        ArrayList<SqlTableConstraint> sqlTableConstraints = new ArrayList<SqlTableConstraint>();
        SqlTableConstraint sqlTableConstraint = columns.get(0);
        if (sqlTableConstraint instanceof SqlUKeyTableConstraint) {
            SqlUKeyTableConstraint sqlUKeyTableConstraint = (SqlUKeyTableConstraint)sqlTableConstraint;
            List<SqlIndexColumnName> indexColumns = sqlUKeyTableConstraint.getIndexColumns();
            ArrayList<SqlIndexColumnName> sqlIndexColumnNames = new ArrayList<SqlIndexColumnName>();
            for (SqlIndexColumnName sqlIndexColumnName : indexColumns) {
                if (!supportDistributedColumns.contains((Object)SqlTypeName.get(sqlIndexColumnName.getColumnType().getIdentifier()))) continue;
                sqlIndexColumnNames.add(sqlIndexColumnName);
            }
            if (sqlIndexColumnNames.isEmpty()) {
                LOGGER.error("Can not found distributed columns!");
                throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Can not found distributed columns! Syntax : distributed columns data type");
            }
            sqlUKeyTableConstraint.setIndexColumns(sqlIndexColumnNames);
            sqlTableConstraints.add(sqlUKeyTableConstraint);
            return sqlTableConstraints;
        }
        return columns;
    }

    static {
        supportDistributedColumns.add(SqlTypeName.TINYINT);
        supportDistributedColumns.add(SqlTypeName.SMALLINT);
        supportDistributedColumns.add(SqlTypeName.INT);
        supportDistributedColumns.add(SqlTypeName.INT64);
        supportDistributedColumns.add(SqlTypeName.FLOAT64);
        supportDistributedColumns.add(SqlTypeName.BIGINT);
        supportDistributedColumns.add(SqlTypeName.BOOL);
        supportDistributedColumns.add(SqlTypeName.BYTES);
        supportDistributedColumns.add(SqlTypeName.NUMERIC);
        supportDistributedColumns.add(SqlTypeName.BIGNUMERIC);
        supportDistributedColumns.add(SqlTypeName.DECIMAL);
        supportDistributedColumns.add(SqlTypeName.DEC);
        supportDistributedColumns.add(SqlTypeName.INTEGER);
        supportDistributedColumns.add(SqlTypeName.MEDIUMINT);
        supportDistributedColumns.add(SqlTypeName.SERIAL);
        supportDistributedColumns.add(SqlTypeName.FIXED);
        supportDistributedColumns.add(SqlTypeName.CHAR);
        supportDistributedColumns.add(SqlTypeName.VARCHAR);
        supportDistributedColumns.add(SqlTypeName.VARCHAR2);
        supportDistributedColumns.add(SqlTypeName.TEXT);
        supportDistributedColumns.add(SqlTypeName.STRING);
        supportDistributedColumns.add(SqlTypeName.STRUCT);
        supportDistributedColumns.add(SqlTypeName.TINYTEXT);
        supportDistributedColumns.add(SqlTypeName.MEDIUMTEXT);
        supportDistributedColumns.add(SqlTypeName.LONGTEXT);
        supportDistributedColumns.add(SqlTypeName.DATE);
        supportDistributedColumns.add(SqlTypeName.TIME);
        supportDistributedColumns.add(SqlTypeName.TIMESTAMP);
        supportDistributedColumns.add(SqlTypeName.DATETIME);
        supportDistributedColumns.add(SqlTypeName.YEAR);
        supportDistributedColumns.add(SqlTypeName.INTERVAL);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_YEAR);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_YEAR_MONTH);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_MONTH);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_DAY);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_DAY_HOUR);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_DAY_MINUTE);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_DAY_SECOND);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_HOUR);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_HOUR_MINUTE);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_HOUR_SECOND);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_MINUTE);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_MINUTE_SECOND);
        supportDistributedColumns.add(SqlTypeName.INTERVAL_SECOND);
        supportDistributedColumns.add(SqlTypeName.ENUM);
        supportDistributedColumns.add(SqlTypeName.SET);
        supportDistributedColumns.add(SqlTypeName.BIGSERIAL);
        supportDistributedColumns.add(SqlTypeName.SMALLSERIAL);
        supportDistributedColumns.add(SqlTypeName.BINARY);
    }
}

