/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.CreateIndexUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlRenameIndex;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlRenameIndex.class)
public class SqlAlterRenameIndexUnParser
implements UnParser<SqlRenameIndex> {
    @Override
    public void unparse(SqlRenameIndex sqlNode, SqlWriter writer, UnParserContext context) {
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        if (stringProperty.toUpperCase(Locale.ROOT).contains("INDEX_RENAME")) {
            writer.append("ALTER INDEX ");
            writer.append(CreateIndexUtil.appendIndexNameWithTableName(sqlNode.getOldIndexName(), sqlNode.getTableName()));
            writer.writeSpace(1).append("RENAME TO ");
            writer.append(CreateIndexUtil.appendIndexNameWithTableName(sqlNode.getNewIndexName(), sqlNode.getTableName()));
            writer.writeSpace(1).append(";");
        } else {
            writer.append("ALTER INDEX").writeSpace(1).append(sqlNode.getOldIndexName()).writeSpace(1).append("RENAME TO");
            writer.writeSpace(1).append(sqlNode.getNewIndexName()).append(";");
        }
    }
}

