/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateDatabase;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateDatabase.class)
public class SqlCreateDataBaseUnParser
implements UnParser<SqlCreateDatabase> {
    private static final Logger LOGGER = LogManager.getLogger(SqlCreateDatabase.class);

    @Override
    public void unparse(SqlCreateDatabase sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isExternal()) {
            LOGGER.error("Create external database is not supported in dws");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create external database");
        }
        ConvertConfig defaultConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(defaultConfig, "table.databaseAsSchema", "true").equalsIgnoreCase("true")) {
            this.schemaUnparser(sqlNode, writer, context, defaultConfig);
        } else {
            this.databaseUnparser(sqlNode, writer, context, defaultConfig);
        }
    }

    public void schemaUnparser(SqlCreateDatabase sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig defaultConfig) {
        LOGGER.info("sql create schema unparse enter");
        writer.append("CREATE").writeSpace(1).append("SCHEMA").writeSpace(1);
        sqlNode.getName().unparse(writer, context);
        writer.sqlEnd();
        LOGGER.info("sql create schema result: {}", (Object)writer.toSqlString());
    }

    public void databaseUnparser(SqlCreateDatabase sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig defaultConfig) {
        LOGGER.info("SqlCreateDatabase unparse enter");
        writer.append("CREATE").writeSpace(1).append("DATABASE").writeSpace(1);
        sqlNode.getName().unparse(writer, context);
        writer.writeSpace(1);
        writer.writeSpace(1).append("ENCODING").writeSpace(1).append("=").writeSpace(1).append(ConfigUtil.getConfigValue(defaultConfig, "table.database.encoding", null));
        writer.writeSpace(1).append("TEMPLATE").writeSpace(1).append("=").writeSpace(1).append(ConfigUtil.getConfigValue(defaultConfig, "table.database.template", null));
        writer.sqlEnd();
        LOGGER.info("SqlCreateDatabase result: {}", (Object)writer.toSqlString());
    }
}

