/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateServer;
import com.huawei.hwclouds.scs.sql.nodes.SqlServerOption;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateServer.class)
public class SqlCreateServerUnParser
implements UnParser<SqlCreateServer> {
    private static final Logger LOGGER = LogManager.getLogger(SqlCreateServerUnParser.class);

    @Override
    public void unparse(SqlCreateServer sqlNode, SqlWriter writer, UnParserContext context) {
        if (!sqlNode.isHavingPort()) {
            LOGGER.error("Creating a server without a port is not supported");
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Creating a server without a port is not supported. Syntax : create server without port");
        }
        this.change(sqlNode, writer);
    }

    private void change(SqlCreateServer sqlNode, SqlWriter writer) {
        this.parameter(sqlNode, writer);
        if (sqlNode.getWrapperName() != null && sqlNode.getWrapperName().equalsIgnoreCase("MYSQL")) {
            writer.append("gc_fdw").writeSpace(1);
        }
        writer.append("OPTIONS").writeSpace(1).append("(");
        String host = null;
        String port = null;
        for (int i = 0; i < sqlNode.getSqlServerOptions().getNodes().size(); ++i) {
            SqlServerOption sqlServerOption = sqlNode.getSqlServerOptions().getNodes().get(i);
            if (sqlServerOption.getPort() != null) {
                port = sqlServerOption.getDecimalLiteral();
                continue;
            }
            if (sqlServerOption.getHost() != null) {
                host = sqlServerOption.getStringLiteral();
                continue;
            }
            if (sqlServerOption.getDatabase() != null) {
                writer.append("DBNAME").writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (sqlServerOption.getUser() != null) {
                writer.append("USERNAME").writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (sqlServerOption.getPassword() != null) {
                writer.append("PASSWORD").writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            writer.append(",").writeSpace(1);
        }
        String ip = host.replace("'", "");
        writer.append("ADDRESS").writeSpace(1).append("'").append(ip).append(":").append(port);
        writer.append("'");
        writer.append(")");
        writer.sqlEnd();
    }

    private void comment(SqlCreateServer sqlNode, SqlWriter writer) {
        if (sqlNode.getWrapperName() != null) {
            writer.append(sqlNode.getWrapperName());
        }
        writer.writeSpace(1).append("OPTIONS").writeSpace(1).append("(");
        for (int i = 0; i < sqlNode.getSqlServerOptions().getNodes().size(); ++i) {
            SqlServerOption sqlServerOption = sqlNode.getSqlServerOptions().getNodes().get(i);
            if (sqlServerOption.getHost() != null) {
                writer.append(sqlServerOption.getHost()).writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (sqlServerOption.getDatabase() != null) {
                writer.append(sqlServerOption.getDatabase()).writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (sqlServerOption.getUser() != null) {
                writer.append(sqlServerOption.getUser()).writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (sqlServerOption.getPassword() != null) {
                writer.append(sqlServerOption.getPassword()).writeSpace(1).append(sqlServerOption.getStringLiteral());
            }
            if (i == sqlNode.getSqlServerOptions().getNodes().size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
        writer.append(")").append(";");
    }

    private void parameter(SqlCreateServer sqlNode, SqlWriter writer) {
        writer.append("CREATE").writeSpace(1).append("SERVER");
        if (sqlNode.getUid() != null) {
            writer.writeSpace(1).append(sqlNode.getUid()).writeSpace(1);
        }
        writer.append("FOREIGN").writeSpace(1).append("DATA").writeSpace(1).append("WRAPPER").writeSpace(1);
    }
}

