/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlArrayAndMapDataType;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlDataTypeSpec.class)
public class SqlDataTypeSpecUnParser
implements UnParser<SqlDataTypeSpec> {
    private static final Logger LOGGER = LogManager.getLogger(SqlDataTypeSpecUnParser.class);

    @Override
    public void unparse(SqlDataTypeSpec sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig bigqeuryConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery")) {
            this.writeAppendBigqueryNumericType(sqlNode, writer);
            this.writeAppendBigqueryCharacterType(sqlNode, writer, context);
            this.writeAppendBigqueryDateType(sqlNode, writer);
            this.writeAppendComplexDataType(sqlNode, writer, context);
        } else if (ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("synapse") || ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("sqlserver")) {
            this.convertSynapseDataType(sqlNode, writer, context);
        } else {
            ConvertConfig config = writer.getConfig(context.getCurrentTableName().getTableName().getIdentifier());
            this.writeAppendNumericType(sqlNode, writer);
            this.writeAppendBitType(sqlNode, writer);
            this.writeAppendCharacterType(sqlNode, writer);
            this.writeAppendSetAndJsonType(sqlNode, writer);
            this.writeAppendDateType(sqlNode, writer);
            this.writeAppendBinaryType(sqlNode, config, writer);
            this.writeAppendGeometricType(sqlNode, config, writer);
            this.writeAppendOtherType(sqlNode, writer);
        }
    }

    private void writeAppendOtherType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case HLL: {
                writer.append("HLL");
                break;
            }
            case BITMAP: {
                writer.append("RoaringBitmap");
                break;
            }
        }
    }

    private void convertSynapseDataType(SqlDataTypeSpec sqlNode, SqlWriter writer, UnParserContext context) {
        this.writeAppendSynapseNumericType(sqlNode, writer);
        this.writeAppendSynapseCharacterType(sqlNode, writer);
        this.writeAppendSynapseDateType(sqlNode, writer);
        this.writeAppendSynapseOtherType(sqlNode, writer);
    }

    private void writeAppendSynapseCharacterType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case NVARCHAR: 
            case VARCHAR: {
                writer.append("VARCHAR");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.VARCHAR);
                break;
            }
            case NCHAR: {
                writer.append("NCHAR");
                this.writePrecisionWithScale(sqlNode, writer);
                break;
            }
            case CHAR: {
                writer.append("CHAR");
                this.writePrecisionWithScale(sqlNode, writer);
                break;
            }
            case VARBINARY: 
            case BINARY: {
                writer.append("BYTEA");
                break;
            }
            case TEXT: {
                writer.append("TEXT");
                break;
            }
        }
    }

    private void writeAppendSynapseOtherType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case MONEY: 
            case SMALLMONEY: {
                writer.append("MONEY");
                sqlNode.setTypeName(SqlTypeName.MONEY);
                break;
            }
            case UNIQUEIDENTIFIER: 
            case XML: {
                writer.append("TEXT");
                break;
            }
        }
    }

    private void writeAppendSynapseNumericType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case FLOAT: 
            case REAL: {
                writer.append("FLOAT");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.FLOAT);
                break;
            }
            case DECIMAL: {
                writer.append("DECIMAL");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.DECIMAL);
                break;
            }
            case NUMERIC: {
                writer.append("NUMERIC");
                this.writePrecisionWithScale(sqlNode, writer);
                break;
            }
            case BIGINT: {
                writer.append("BIGINT");
                break;
            }
            case INT: {
                writer.append("INT");
                break;
            }
            case SMALLINT: {
                writer.append("SMALLINT");
                break;
            }
            case TINYINT: {
                writer.append("TINYINT");
                break;
            }
            case BIT: {
                writer.append("BIT");
                break;
            }
        }
    }

    private void writeAppendSynapseDateType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case DATETIMEOFFSET: {
                writer.append("TIMESTAMPTZ");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.TIMESTAMPTZ);
                break;
            }
            case DATETIME2: 
            case DATETIME: 
            case SMALLDATETIME: {
                writer.append("TIMESTAMP");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.TIMESTAMP);
                break;
            }
            case DATE: {
                writer.append("DATE");
                break;
            }
            case TIME: {
                writer.append("TIME");
                this.writePrecisionOnly(sqlNode, writer);
                break;
            }
        }
    }

    private void writeAppendComplexDataType(SqlDataTypeSpec sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getTypeName()) {
            case ARRAY: {
                SqlArrayAndMapDataType sqlArrayAndMapDataType = sqlNode.getSqlArrayAndMapDataType();
                int dimension = 0;
                SqlDataTypeSpec typeName = new SqlDataTypeSpec();
                while (sqlArrayAndMapDataType != null) {
                    ++dimension;
                    if (sqlArrayAndMapDataType.getKeyType().getSqlArrayAndMapDataType() != null) {
                        typeName = sqlArrayAndMapDataType.getKeyType();
                        sqlArrayAndMapDataType = sqlArrayAndMapDataType.getKeyType().getSqlArrayAndMapDataType();
                        continue;
                    }
                    typeName = sqlArrayAndMapDataType.getKeyType();
                    break;
                }
                typeName.unparse(writer, context);
                for (int i = 0; i < dimension; ++i) {
                    writer.append("[]");
                }
                writer.writeSpace(1);
                break;
            }
            case MAP: {
                sqlNode.setTypeName(SqlTypeName.TEXT);
                writer.append("TEXT");
                break;
            }
        }
    }

    private void writeAppendNumericType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        this.writeAppendNumericOtherType(sqlNode, writer);
        this.writeAppendIntType(sqlNode, writer);
        this.writeAppendFloatingPoint(sqlNode, writer);
        this.writeAppendSerial(sqlNode, writer);
    }

    private void writeAppendBitType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        if (sqlNode.getTypeName().equals((Object)SqlTypeName.BIT)) {
            writer.append("BIT");
            if (sqlNode.getPrecision() != null && sqlNode.getPrecision() <= 0L) {
                sqlNode.setPrecision(1L);
            }
            this.writePrecisionOnly(sqlNode, writer);
            return;
        }
    }

    private void writeAppendSetAndJsonType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        switch (sqlNode.getTypeName()) {
            case SET: 
            case ENUM: {
                writer.append("VARCHAR");
                this.writeCollection(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.VARCHAR);
                break;
            }
            case JSON: {
                if (stringProperty.contains("811")) {
                    sqlNode.setTypeName(SqlTypeName.JSON);
                    writer.append("JSON");
                    break;
                }
                sqlNode.setTypeName(SqlTypeName.JSONB);
                writer.append("JSONB");
                break;
            }
        }
    }

    private void writeAppendNumericOtherType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case DECIMAL: 
            case NUMERIC: 
            case DEC: {
                writer.append("DECIMAL");
                this.writePrecisionWithScale(sqlNode, writer);
                sqlNode.setTypeName(SqlTypeName.DECIMAL);
                break;
            }
            case FIXED: {
                if (sqlNode.getPrecision() != null) {
                    writer.append("DECIMAL");
                    this.writePrecisionWithScale(sqlNode, writer);
                } else {
                    writer.append("DECIMAL(10, 0)");
                }
                sqlNode.setTypeName(SqlTypeName.DECIMAL);
                break;
            }
            case BOOLEAN: 
            case BOOL: {
                sqlNode.setTypeName(SqlTypeName.BOOLEAN);
                writer.append("BOOLEAN");
                break;
            }
        }
    }

    private void writeAppendBigqueryNumericType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case INT32: {
                writer.append("INT");
                sqlNode.setTypeName(SqlTypeName.INT);
                break;
            }
            case INT64: {
                writer.append("BIGINT");
                sqlNode.setTypeName(SqlTypeName.BIGINT);
                break;
            }
            case BOOLEAN: 
            case BOOL: {
                writer.append("BOOLEAN");
                break;
            }
            case FLOAT64: {
                writer.append("DOUBLE PRECISION");
                sqlNode.setTypeName(SqlTypeName.DOUBLE_PRECISION);
                break;
            }
            case NUMERIC: {
                writer.append("DECIMAL");
                this.writePrecisionWithScale(sqlNode, writer);
                break;
            }
            case BIGNUMERIC: {
                writer.append("DECIMAL");
                sqlNode.setTypeName(SqlTypeName.DECIMAL);
                break;
            }
        }
    }

    private void writeAppendBigqueryCharacterType(SqlDataTypeSpec sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getTypeName()) {
            case BYTES: {
                writer.append("BYTEA");
                sqlNode.setTypeName(SqlTypeName.BYTEA);
                break;
            }
            case STRING: {
                writer.append("VARCHAR2");
                sqlNode.setTypeName(SqlTypeName.VARCHAR2);
                break;
            }
            case JSON: {
                writer.append("JSON");
                break;
            }
            case GEOGRAPHY: 
            case STRUCT: {
                for (int i = 0; i < context.getStructInfoList().size(); ++i) {
                    String columnName = context.getStructInfoList().get(i).getColumnName().getIdentifier();
                    String fieldName = context.getStructInfoList().get(i).getFieldName().getIdentifier();
                    if (context.columnNameForStructType != null) {
                        String structName = context.columnNameForStructType.getIdentifier();
                        if (!structName.equalsIgnoreCase(columnName + "_" + fieldName)) continue;
                        writer.append(context.getStructInfoList().get(i).getTableName() + "_" + columnName + "_" + fieldName);
                        continue;
                    }
                    String appendName = sqlNode.getColumnName().getIdentifier() + "_" + sqlNode.getColumnName().getIdentifier();
                    if (!appendName.equalsIgnoreCase(columnName + "_" + fieldName)) continue;
                    writer.append(context.getStructInfoList().get(i).getTableName() + "_" + columnName + "_" + fieldName);
                }
                break;
            }
        }
    }

    private void writeAppendBigqueryDateType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case DATE: {
                writer.append("DATE");
                break;
            }
            case TIME: {
                writer.append("TIME");
                break;
            }
            case DATETIME: 
            case TIMESTAMP: {
                writer.append("TIMESTAMP");
                break;
            }
            case INTERVAL: {
                writer.append("INTERVAL");
                break;
            }
        }
    }

    private void writeAppendIntType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case TINYINT: {
                if (sqlNode.getUnsigned().booleanValue()) {
                    writer.append("TINYINT");
                    break;
                }
                sqlNode.setTypeName(SqlTypeName.SMALLINT);
                writer.append("SMALLINT");
                break;
            }
            case SMALLINT: {
                if (sqlNode.getUnsigned().booleanValue()) {
                    sqlNode.setTypeName(SqlTypeName.INTEGER);
                    writer.append("INTEGER");
                    break;
                }
                writer.append("SMALLINT");
                break;
            }
            case MEDIUMINT: {
                sqlNode.setTypeName(SqlTypeName.INTEGER);
                writer.append("INTEGER");
                break;
            }
            case INT: 
            case INTEGER: {
                if (sqlNode.getUnsigned().booleanValue()) {
                    sqlNode.setTypeName(SqlTypeName.BIGINT);
                    writer.append("BIGINT");
                    break;
                }
                sqlNode.setTypeName(SqlTypeName.INTEGER);
                writer.append("INTEGER");
                break;
            }
            case BIGINT: 
            case LARGEINT: {
                if (sqlNode.getUnsigned().booleanValue()) {
                    sqlNode.setTypeName(SqlTypeName.NUMERIC);
                    writer.append("NUMERIC");
                    break;
                }
                writer.append("BIGINT");
                break;
            }
        }
    }

    private void writeAppendFloatingPoint(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case FLOAT: {
                sqlNode.setTypeName(SqlTypeName.REAL);
                writer.append("REAL");
                break;
            }
            case DOUBLE: 
            case DOUBLE_PRECISION: {
                sqlNode.setTypeName(SqlTypeName.DOUBLE_PRECISION);
                writer.append("DOUBLE PRECISION");
                break;
            }
            case REAL: {
                String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
                if (stringProperty.toUpperCase(Locale.ROOT).contains("REAL_AS_FLOAT")) {
                    writer.append("REAL");
                    break;
                }
                ConvertConfig config = writer.getConfig("param.config.flag");
                if (ConfigUtil.getConfigValue(config, "table.database.realAsFloat", "false").equalsIgnoreCase("true")) {
                    writer.append("REAL");
                    break;
                }
                sqlNode.setTypeName(SqlTypeName.DOUBLE_PRECISION);
                writer.append("DOUBLE PRECISION");
                break;
            }
        }
    }

    private void writeAppendSerial(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case SERIAL: {
                writer.append("SERIAL");
                break;
            }
            case SMALLSERIAL: {
                writer.append("SMALLSERIAL");
                break;
            }
            case BIGSERIAL: {
                writer.append("BIGSERIAL");
                break;
            }
        }
    }

    private void writeAppendCharacterType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case NCHAR: 
            case CHARACTER: {
                sqlNode.setTypeName(SqlTypeName.CHAR);
                writer.append("CHAR");
                if (sqlNode.getPrecision() != null) {
                    if (sqlNode.getPrecision() <= 0L) {
                        sqlNode.setPrecision(1L);
                    } else {
                        sqlNode.setPrecision(sqlNode.getPrecision() * 4L);
                    }
                } else {
                    sqlNode.setPrecision(4L);
                }
                this.writePrecisionOnly(sqlNode, writer);
                break;
            }
            case NVARCHAR: 
            case VARCHAR: 
            case CHAR: 
            case CHARACTERVARYING: {
                sqlNode.setTypeName(SqlTypeName.VARCHAR);
                writer.append("VARCHAR");
                if (sqlNode.getPrecision() != null) {
                    if (sqlNode.getPrecision() <= 0L) {
                        sqlNode.setPrecision(1L);
                    } else {
                        sqlNode.setPrecision(sqlNode.getPrecision() * 4L);
                    }
                }
                this.writePrecisionOnly(sqlNode, writer);
                break;
            }
            case TEXT: 
            case ARRAY: 
            case MAP: 
            case STRING: 
            case TINYTEXT: 
            case LONGTEXT: 
            case MEDIUMTEXT: {
                sqlNode.setTypeName(SqlTypeName.TEXT);
                writer.append("TEXT");
                break;
            }
        }
    }

    private void writeAppendDateType(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case DATE: {
                writer.append("DATE");
                break;
            }
            case TIME: {
                writer.append("TIME");
                this.writePrecisionOnly(sqlNode, writer);
                writer.writeSpace(1).append("WITHOUT").writeSpace(1).append("TIME").writeSpace(1).append("ZONE");
                break;
            }
            case YEAR: {
                sqlNode.setTypeName(SqlTypeName.SMALLINT);
                writer.append("SMALLINT");
                break;
            }
            case DATETIME: {
                sqlNode.setTypeName(SqlTypeName.TIMESTAMP);
                writer.append("TIMESTAMP");
                if (sqlNode.getPrecision() == null) {
                    sqlNode.setPrecision(Long.valueOf("0"));
                }
                this.writePrecisionOnly(sqlNode, writer);
                writer.writeSpace(1).append("WITHOUT").writeSpace(1).append("TIME").writeSpace(1).append("ZONE");
                break;
            }
            case TIMESTAMP: {
                writer.append("TIMESTAMP");
                this.writePrecisionOnly(sqlNode, writer);
                writer.writeSpace(1).append("WITH").writeSpace(1).append("TIME").writeSpace(1).append("ZONE");
                break;
            }
        }
    }

    private void writeAppendGeometricType(SqlDataTypeSpec sqlNode, ConvertConfig config, SqlWriter writer) {
        String orientationConfig = ConfigUtil.getConfigValue(config, "table.orientation", "ROW");
        switch (sqlNode.getTypeName()) {
            case MULTIPOINT: 
            case MULTILINESTRING: {
                if (!orientationConfig.equalsIgnoreCase("ROW")) {
                    LOGGER.error("The multilinestring type is not supported in dsc column-oriented table");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ROW STORE TYPE" + (Object)((Object)sqlNode.getTypeName()));
                }
                sqlNode.setTypeName(SqlTypeName.BOX);
                writer.append("BOX");
                break;
            }
            case MULTIPOLYGON: 
            case LINESTRING: 
            case POLYGON: {
                if (!orientationConfig.equalsIgnoreCase("ROW")) {
                    LOGGER.error("The polygon type is not supported in dsc column-oriented table");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ROW STORE TYPE" + (Object)((Object)sqlNode.getTypeName()));
                }
                sqlNode.setTypeName(SqlTypeName.POLYGON);
                writer.append("POLYGON");
                break;
            }
            case GEOMETRY: {
                if (!orientationConfig.equalsIgnoreCase("ROW")) {
                    LOGGER.error("The geometry type is not supported in dsc column-oriented table");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ROW STORE TYPE" + (Object)((Object)sqlNode.getTypeName()));
                }
                writer.append("GEOMETRY");
                break;
            }
            case GEOMETRYCOLLECTION: {
                if (!orientationConfig.equalsIgnoreCase("ROW")) {
                    LOGGER.error("The geometrycollection type is not supported in dsc column-oriented table");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ROW STORE TYPE" + (Object)((Object)sqlNode.getTypeName()));
                }
                writer.append("CIRCLE");
                break;
            }
            case POINT: {
                if (!orientationConfig.equalsIgnoreCase("ROW")) {
                    LOGGER.error("The point type is not supported in dsc column-oriented table");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ROW STORE TYPE" + (Object)((Object)sqlNode.getTypeName()));
                }
                writer.append("POINT");
                break;
            }
        }
    }

    private void writeAppendBinaryType(SqlDataTypeSpec sqlNode, ConvertConfig config, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case VARBINARY: 
            case BINARY: 
            case CHARBYTE: {
                sqlNode.setTypeName(SqlTypeName.BYTEA);
                writer.append("BYTEA");
                break;
            }
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (!ConfigUtil.getConfigValue(config, "table.orientation", "ROW").equalsIgnoreCase("ROW")) {
                    sqlNode.setTypeName(SqlTypeName.BYTEA);
                    writer.append("BYTEA");
                    break;
                }
                sqlNode.setTypeName(SqlTypeName.BLOB);
                writer.append("BLOB");
                break;
            }
        }
    }

    private void writePrecisionOnly(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        if (sqlNode.getPrecision() != null) {
            writer.append("(");
            writer.append(sqlNode.getPrecision().toString());
            writer.append(")");
        }
    }

    private void writePrecisionWithScale(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        if (sqlNode.getPrecision() != null) {
            writer.append("(");
            writer.append(sqlNode.getPrecision().toString());
            if (sqlNode.getScale() != null) {
                writer.append(",").append(sqlNode.getScale().toString());
            }
            writer.append(")");
        }
    }

    private void writeCollection(SqlDataTypeSpec sqlNode, SqlWriter writer) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (sqlNode.getStringLiteral() != null) {
            writer.append("(");
            int pre = 0;
            if (sqlNode.getTypeName().toString().equalsIgnoreCase("enum")) {
                int i;
                for (i = 0; i < sqlNode.getStringLiteral().size(); ++i) {
                    int len = QuoteUtils.removeAllQuote(sqlNode.getStringLiteral().get(i)).length();
                    pre = len > pre ? len : pre;
                }
                writer.append(String.valueOf(pre * 4));
                writer.append(")").writeSpace(1);
                writer.append("CHECK").writeSpace(1).append("(");
                writer.append(sqlNode.getFiledNameForEnum()).writeSpace(1).append("IN").append("(");
                for (i = 0; i < sqlNode.getStringLiteral().size(); ++i) {
                    writer.append(sqlNode.getStringLiteral().get(i));
                    if (i == sqlNode.getStringLiteral().size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
                if (ConfigUtil.getConfigValue(config, "table.create.type.enum", "false").equalsIgnoreCase("true")) {
                    writer.append(") OR " + sqlNode.getFiledNameForEnum() + " IS NULL) ");
                } else {
                    writer.append(", ''))");
                }
            } else if (sqlNode.getTypeName().toString().equalsIgnoreCase("set")) {
                int i;
                for (i = 0; i < sqlNode.getStringLiteral().size(); ++i) {
                    int len = QuoteUtils.removeAllQuote(sqlNode.getStringLiteral().get(i)).length();
                    pre += len;
                }
                writer.append(String.valueOf((pre += sqlNode.getStringLiteral().size() - 1) * 4));
                writer.append(")");
                if (!ConfigUtil.getConfigValue(config, "table.create.type.set", "false").equalsIgnoreCase("false") && sqlNode.getStringLiteral().size() < 5) {
                    writer.append("CHECK").writeSpace(1).append("(").append(sqlNode.getFiledNameForEnum()).writeSpace(1).append("IN").append("(");
                    for (i = 1; i <= sqlNode.getStringLiteral().size(); ++i) {
                        SqlDataTypeSpecUnParser.setMembers(sqlNode.getStringLiteral(), i, writer);
                        if (i == sqlNode.getStringLiteral().size()) continue;
                        writer.append(", ");
                    }
                    writer.append(")) ");
                }
            }
        }
    }

    public static void setMembers(List<String> members, int membersCount, SqlWriter writer) {
        Stream<Object> stream = members.stream();
        for (int i = 1; i < membersCount; ++i) {
            stream = stream.flatMap(j -> members.stream().filter(k -> !j.contains((CharSequence)k)).map(k -> j.concat((String)k)));
        }
        List resList = stream.collect(Collectors.toList());
        for (int i = 0; i < resList.size(); ++i) {
            String checkMember = (String)resList.get(i);
            checkMember = checkMember.replace("''", ",");
            if (i != resList.size() - 1) {
                writer.append(checkMember).append(",").writeSpace(1);
                continue;
            }
            writer.append(checkMember);
        }
    }
}

