/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.util.ColumnUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpressionAtom;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlExpressionAtom.class)
public class SqlExpressionAtomUnParser
implements UnParser<SqlExpressionAtom> {
    private static final Logger LOGGER = LogManager.getLogger(SqlExpressionAtomUnParser.class);

    @Override
    public void unparse(SqlExpressionAtom sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSqlConstantExpressionAtom() != null) {
            sqlNode.getSqlConstantExpressionAtom().unparse(writer, context);
        } else if (sqlNode.getFullColumnName() != null) {
            String fullColumn = sqlNode.getFullColumnName();
            fullColumn = fullColumn.replace("`", "\"");
            fullColumn = ColumnUtil.getFullColumnName(fullColumn);
            writer.append(fullColumn).writeSpace(1);
        } else if (sqlNode.getSqlFunctionCallExpressionAtom() != null) {
            sqlNode.getSqlFunctionCallExpressionAtom().getSqlFunctionCall().unparse(writer, context);
        } else if (sqlNode.getSqlCollateExpressionAtom() != null) {
            sqlNode.getSqlCollateExpressionAtom().getSqlExpressionAtom().unparse(writer, context);
            writer.append("/* COLLATE").writeSpace(1);
            writer.append(sqlNode.getSqlCollateExpressionAtom().getCollationName()).writeSpace(1).append("*/ ");
        } else if (sqlNode.getMysqlVariable() != null) {
            writer.append(sqlNode.getMysqlVariable()).writeSpace(1);
        } else if (sqlNode.getSqlUnaryExpressionAtom() != null) {
            writer.append(sqlNode.getSqlUnaryExpressionAtom().getUnaryOperator()).writeSpace(1);
            sqlNode.getSqlUnaryExpressionAtom().getSqlExpressionAtom().unparse(writer, context);
        } else if (sqlNode.getSqlBinaryExpressionAtom() != null) {
            writer.append(sqlNode.getSqlBinaryExpressionAtom().getKeywords()).writeSpace(1);
            sqlNode.getSqlBinaryExpressionAtom().getSqlExpressionAtom().unparse(writer, context);
        } else if (sqlNode.getSqlNestedAndCheckRowExpressionAtom() != null) {
            if (sqlNode.getSqlNestedAndCheckRowExpressionAtom().getKeywords() != null) {
                writer.append(sqlNode.getSqlNestedAndCheckRowExpressionAtom().getKeywords()).writeSpace(1);
            }
            writer.append("(");
            for (int i = 0; i < sqlNode.getSqlNestedAndCheckRowExpressionAtom().getSqlExpressionSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getSqlNestedAndCheckRowExpressionAtom().getSqlExpressionSqlNodeList().getNodes().get(i).unparse(writer, context);
                if (i == sqlNode.getSqlNestedAndCheckRowExpressionAtom().getSqlExpressionSqlNodeList().getNodes().size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getSqlExistsAndSubQueryExpressionAtom() != null) {
            if (sqlNode.getSqlExistsAndSubQueryExpressionAtom().getKeywords() != null) {
                writer.append(sqlNode.getSqlExistsAndSubQueryExpressionAtom().getKeywords()).writeSpace(1);
            }
            writer.append("(");
            if (sqlNode.getSqlExistsAndSubQueryExpressionAtom().getSqlSelectStatement() != null) {
                sqlNode.getSqlExistsAndSubQueryExpressionAtom().getSqlSelectStatement().unparse(writer, context);
            } else {
                sqlNode.getSqlExistsAndSubQueryExpressionAtom().getSqlTableElement().unparse(writer, context);
            }
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getSqlIntervalExpressionAtom() != null) {
            this.intervalExpressionAtomConvert(sqlNode, writer, context);
        } else if (sqlNode.getSqlOpExpressionAtom() != null) {
            boolean jsonOp;
            sqlNode.getSqlOpExpressionAtom().getFrontExpressionAtom().unparse(writer, context);
            boolean bl = jsonOp = sqlNode.getSqlOpExpressionAtom().getOp().equals("->") || sqlNode.getSqlOpExpressionAtom().getOp().equals("->>");
            if (sqlNode.getSqlOpExpressionAtom().getExpressionType() != null && sqlNode.getSqlOpExpressionAtom().getExpressionType().equals("json") && jsonOp) {
                writer.append("::jsonb ");
                context.setJsonCase(true);
            }
            if (sqlNode.getSqlOpExpressionAtom().getOp().equals("^")) {
                writer.append("# ");
            } else if (context.isJsonUnquoteCase()) {
                writer.append(", ").writeSpace(1);
            } else {
                writer.append(sqlNode.getSqlOpExpressionAtom().getOp()).writeSpace(1);
            }
            sqlNode.getSqlOpExpressionAtom().getBehindExpressionAtom().unparse(writer, context);
            context.setJsonCase(false);
        } else if (sqlNode.getSqlMathExpressionAtom() != null) {
            this.mathExpressionAtomConvert(sqlNode, writer, context);
        }
    }

    private void mathExpressionAtomConvert(SqlExpressionAtom sqlNode, SqlWriter writer, UnParserContext context) {
        String mathOperator = sqlNode.getSqlMathExpressionAtom().getMathOperator();
        if (mathOperator.equals("/")) {
            writer.append("if (").writeSpace(1);
            SqlWriter sqlWriter = writer.cloneEmpty();
            sqlNode.getSqlMathExpressionAtom().getRight().unparse(sqlWriter, context);
            writer.append(sqlWriter.toSqlString().getSql()).append("= 0").append(",").writeSpace(1);
            writer.append("null").append(",").writeSpace(1);
            sqlNode.getSqlMathExpressionAtom().getLeft().unparse(writer, context);
            writer.append(mathOperator).writeSpace(1);
            writer.append(sqlWriter.toSqlString().getSql());
            writer.append(")");
        } else if (mathOperator.equalsIgnoreCase("div") || mathOperator.equalsIgnoreCase("mod")) {
            writer.append(mathOperator).append("(");
            sqlNode.getSqlMathExpressionAtom().getLeft().unparse(writer, context);
            writer.append(", ");
            sqlNode.getSqlMathExpressionAtom().getRight().unparse(writer, context);
            writer.append(")");
        } else if (mathOperator.equalsIgnoreCase("-") || mathOperator.equalsIgnoreCase("+")) {
            SqlExpressionAtom left = sqlNode.getSqlMathExpressionAtom().getLeft();
            if (left.getSqlConstantExpressionAtom() != null && left.getSqlConstantExpressionAtom().getLiteral().getLiteral().startsWith("'") && left.getSqlConstantExpressionAtom().getLiteral().getLiteral().endsWith("'") && sqlNode.getSqlMathExpressionAtom().getRight().getSqlIntervalExpressionAtom() != null) {
                int length = QuoteUtils.removeSingleQuote(left.getSqlConstantExpressionAtom().getLiteral().getLiteral()).length();
                if (length == 8) {
                    writer.append("time ");
                } else if (length == 10) {
                    writer.append("date ");
                } else {
                    writer.append("timestamp ");
                }
            }
            left.unparse(writer, context);
            writer.append(mathOperator).writeSpace(1);
            sqlNode.getSqlMathExpressionAtom().getRight().unparse(writer, context);
        } else {
            sqlNode.getSqlMathExpressionAtom().getLeft().unparse(writer, context);
            writer.append(mathOperator).writeSpace(1);
            sqlNode.getSqlMathExpressionAtom().getRight().unparse(writer, context);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intervalExpressionAtomConvert(SqlExpressionAtom sqlNode, SqlWriter writer, UnParserContext context) {
        SqlWriter sqlWriter = writer.cloneEmpty();
        sqlNode.getSqlIntervalExpressionAtom().getSqlExpression().unparse(sqlWriter, context);
        String str = sqlWriter.toSqlString().toString();
        if (str.contains("'")) {
            str = str.replace("'", "");
        }
        str = str.trim();
        String reg = "^-?[0-9]+";
        Pattern pattern = Pattern.compile(reg);
        if (sqlNode.getSqlIntervalExpressionAtom().getKeywords().equalsIgnoreCase("date_add_interval")) {
            writer.append("CAST(");
            writer.append(str).writeSpace(1).append("||").writeSpace(1);
            writer.append("'").append(sqlNode.getSqlIntervalExpressionAtom().getIntervalType()).append("'").writeSpace(1);
            writer.append("AS INTERVAL)").writeSpace(1);
            return;
        }
        if (sqlNode.getSqlIntervalExpressionAtom().getKeywords().equalsIgnoreCase("date_sub_interval") && !pattern.matcher(str).matches()) {
            writer.append("CAST(");
            writer.append(str).writeSpace(1).append("||").writeSpace(1);
            writer.append("'").append(sqlNode.getSqlIntervalExpressionAtom().getIntervalType()).append("'").writeSpace(1);
            writer.append("AS INTERVAL)").writeSpace(1);
            return;
        }
        if (!pattern.matcher(str).matches()) {
            if (sqlNode.getSqlIntervalExpressionAtom().getIntervalType().equalsIgnoreCase("day")) {
                writer.append(str);
                return;
            }
            LOGGER.error("Other time type conversions are not supported.");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Other time type : " + sqlNode.getSqlIntervalExpressionAtom().getIntervalType());
        }
        if (str.trim().charAt(0) != '\'') {
            str = '\'' + str + '\'';
        }
        writer.append("INTERVAL").writeSpace(1);
        writer.append(str);
        writer.append(sqlNode.getSqlIntervalExpressionAtom().getIntervalType()).writeSpace(1);
    }
}

