/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.util.ColumnUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlGroupByItem;
import com.huawei.hwclouds.scs.sql.nodes.SqlGroupingElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectElement;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlGroupingElement.class)
public class SqlGroupingElementUnParser
implements UnParser<SqlGroupingElement> {
    @Override
    public void unparse(SqlGroupingElement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isGroupingSets()) {
            writer.append("GROUPING SETS( ");
            List<SqlGroupingElement> sqlGroupingElements = sqlNode.getSqlGroupingElements().getNodes();
            for (int i = 0; i < sqlGroupingElements.size(); ++i) {
                sqlGroupingElements.get(i).unparse(writer, context);
                if (i == sqlGroupingElements.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        } else if (sqlNode.getGroupByType() != null) {
            writer.append(sqlNode.getGroupByType().toUpperCase(Locale.ROOT)).append("( ");
            this.getGroupByItem(sqlNode, writer, context);
            writer.append(") ");
        } else if (sqlNode.isBrackets()) {
            writer.append("() ");
        } else {
            this.getGroupByItem(sqlNode, writer, context);
        }
    }

    private void getGroupByItem(SqlGroupingElement sqlNode, SqlWriter writer, UnParserContext context) {
        List<SqlGroupByItem> sqlGroupByItems = sqlNode.getSqlGroupByItems().getNodes();
        SqlNodeList<SqlSelectElement> selectElementSqlNodeList = sqlNode.getSelectElementSqlNodeList();
        ColumnUtil.fullGroupByArgs(selectElementSqlNodeList, sqlGroupByItems, writer, context, this);
    }
}

