/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlHavingClause;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlHavingClause.class)
public class SqlHavingClauseUnParser
implements UnParser<SqlHavingClause> {
    @Override
    public void unparse(SqlHavingClause sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.database.havingAddGroupBy", "true").equalsIgnoreCase("true")) {
            if (sqlNode.isIfHaveStar()) {
                writer.newLine().append("WHERE").writeSpace(1);
            } else {
                if (sqlNode.getCondition() != null && sqlNode.getSelectElementSqlNodeList() != null) {
                    int i;
                    writer.newLine().append("GROUP BY").writeSpace(1);
                    ArrayList<Integer> groupByList = new ArrayList<Integer>();
                    for (i = 0; i < sqlNode.getSelectElementSqlNodeList().getNodes().size(); ++i) {
                        SqlWriter sqlWriter = writer.cloneEmpty();
                        sqlNode.getSelectElementSqlNodeList().getNodes().get(i).unparse(sqlWriter, context);
                        String sql = sqlWriter.toSqlString().getSql();
                        String reg = "[\\S+\\s+]*(sum|count|max|min|avg)\\s*\\(.*";
                        Pattern pattern = Pattern.compile(reg, 2);
                        if (pattern.matcher(sql).matches()) continue;
                        groupByList.add(i + 1);
                    }
                    for (i = 0; i < groupByList.size(); ++i) {
                        writer.append(String.valueOf(groupByList.get(i)));
                        if (i == groupByList.size() - 1) continue;
                        writer.append(",").writeSpace(1);
                    }
                }
                writer.newLine().append("HAVING").writeSpace(1);
            }
        } else {
            writer.newLine().append("HAVING").writeSpace(1);
        }
        sqlNode.getCondition().unparse(writer, context);
    }
}

