/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlIdentifier.class)
public class SqlIdentifierUnParser
implements UnParser<SqlIdentifier> {
    @Override
    public void unparse(SqlIdentifier sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig configForCase = writer.getConfig("param.config.flag");
        if ("doris".equalsIgnoreCase(ConfigUtil.getConfigValue(configForCase, "table.origin.database.type", "mysql"))) {
            String identifier = sqlNode.getIdentifier();
            identifier = identifier.replaceAll("default_cluster:", "");
            sqlNode.setIdentifier(identifier);
        }
        if (sqlNode.isCaseSensitivity()) {
            writer.append(QuoteUtils.addDoubleQuote(sqlNode.getIdentifier()));
        } else {
            String caseSensitive = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_COLUMN_CASE_SENSITIVE.getValue());
            if (caseSensitive.equalsIgnoreCase("true")) {
                writer.append(QuoteUtils.addDoubleQuote(sqlNode.getIdentifier()));
            } else {
                String ansiQuote = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
                if (ansiQuote.toUpperCase(Locale.ROOT).contains("ANSI_QUOTES")) {
                    sqlNode.setIdentifier(QuoteUtils.removeDoubleQuote(sqlNode.getIdentifier()));
                }
                if (ConfigUtil.getConfigValue(configForCase, "table.create.columnCase", "true").equalsIgnoreCase("true")) {
                    writer.append(QuoteUtils.addDoubleQuote(sqlNode.getIdentifier().toLowerCase(Locale.US)));
                } else {
                    writer.append(QuoteUtils.addDoubleQuote(sqlNode.getIdentifier()));
                }
            }
        }
    }
}

