/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlFromClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlInsertReplaceStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSource;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdatedElement;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlInsertReplaceStatement.class)
public class SqlInsertUnParser
implements UnParser<SqlInsertReplaceStatement> {
    private static final Logger LOGGER = LogManager.getLogger(SqlInsertReplaceStatement.class);

    @Override
    public void unparse(SqlInsertReplaceStatement sqlNode, SqlWriter writer, UnParserContext context) {
        SqlFromClause sqlFromClause;
        LOGGER.info("SqlInsert unparse enter");
        boolean isHaveAs = false;
        if (sqlNode.getSqlSimpleSelect() != null && (sqlFromClause = sqlNode.getSqlSimpleSelect().getSqlQuerySpecification().getSqlFromClause()) != null && sqlFromClause.getSqlTableSources() != null) {
            SqlNodeList<SqlTableSource> sqlTableSource = sqlFromClause.getSqlTableSources().getSqlTableSource();
            for (int i = 0; i < sqlTableSource.getNodes().size(); ++i) {
                if (!sqlTableSource.getNodes().get(i).getSqlTableSourceItem().isIfHaveAs()) continue;
                isHaveAs = true;
            }
        }
        if (sqlNode.isHavingAs() || isHaveAs) {
            LOGGER.error("Alias is not supported in DWS");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "as alias_name on duplicate key update");
        }
        context.setCurrentTableName(sqlNode.getTableName());
        if (sqlNode.getSqlSimpleSelect() != null || sqlNode.getSqlParenthesisSelect() != null || sqlNode.getSqlCollectionSelect() != null || sqlNode.getSqlTableElement() != null) {
            writer.append("INSERT").writeSpace(1);
            if (sqlNode.getDuplicationPriority() != null) {
                writer.append(sqlNode.getDuplicationPriority().toString()).writeSpace(1);
            }
            writer.append("INTO").writeSpace(1);
            context.setOriSchema(true);
            sqlNode.getTableName().unparse(writer, context);
            context.setOriSchema(false);
            writer.writeSpace(1);
            if (sqlNode.getParameterList() != null) {
                writer.append("(").writeSpace(1);
                for (int i = 0; i < sqlNode.getParameterList().getNodes().size(); ++i) {
                    sqlNode.getParameterList().getNodes().get(i).unparse(writer, context);
                    if (i != sqlNode.getParameterList().getNodes().size() - 1) {
                        writer.append(", ");
                    }
                    this.unparseComment(sqlNode.getParameterList().getNodes().get(i), writer);
                }
                writer.append(")").writeSpace(1);
            }
            if (sqlNode.getSqlSimpleSelect() != null) {
                sqlNode.getSqlSimpleSelect().unparse(writer, context);
            } else if (sqlNode.getSqlParenthesisSelect() != null) {
                sqlNode.getSqlParenthesisSelect().unparse(writer, context);
            } else if (sqlNode.getSqlCollectionSelect() != null) {
                sqlNode.getSqlCollectionSelect().unparse(writer, context);
            }
            if (sqlNode.getSqlTableElement() != null) {
                sqlNode.getSqlTableElement().unparse(writer, context);
            }
            this.duplicate(sqlNode, writer, context);
            writer.sqlEnd();
        }
        if (sqlNode.getSqlUpdatedElement().getNodes().size() > 0) {
            writer.append("INSERT").writeSpace(1);
            this.priority(sqlNode, writer);
            writer.append("INTO").writeSpace(1);
            context.setOriSchema(true);
            sqlNode.getTableName().unparse(writer, context);
            context.setOriSchema(false);
            writer.writeSpace(1);
            SqlNodeList<SqlUpdatedElement> row = sqlNode.getSqlUpdatedElement().getNodes().get(0);
            for (int i1 = 0; i1 < row.getNodes().size(); ++i1) {
                if (row.getNodes().get(i1).getColumnName() == null) continue;
                if (i1 == 0) {
                    writer.append("(");
                }
                row.getNodes().get(i1).getColumnName().unparse(writer, context);
                if (i1 != row.getNodes().size() - 1) {
                    writer.append(",");
                    this.unparseComment(row.getNodes().get(i1), writer);
                    continue;
                }
                this.unparseComment(row.getNodes().get(i1), writer);
                writer.append(")");
            }
            writer.writeSpace(1);
            writer.append("VALUES").writeSpace(1);
            for (int i = 0; i < sqlNode.getSqlUpdatedElement().getNodes().size(); ++i) {
                writer.append("(");
                SqlNodeList<SqlUpdatedElement> value = sqlNode.getSqlUpdatedElement().getNodes().get(i);
                this.unparseValuesContent(writer, value, context);
                writer.append(")");
                if (i == sqlNode.getSqlUpdatedElement().getNodes().size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            this.duplicate(sqlNode, writer, context);
            writer.sqlEnd();
        }
    }

    private void priority(SqlInsertReplaceStatement sqlNode, SqlWriter writer) {
        if (sqlNode.getDuplicationPriority() != null) {
            String priority = sqlNode.getDuplicationPriority().name();
            if (priority.equalsIgnoreCase("OVERWRITE")) {
                LOGGER.error("The conversion is not supported in insert overwrite into values");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "insert overwrite into values");
            }
            if (priority.equalsIgnoreCase("HIGH_PRIORITY") || priority.equalsIgnoreCase("LOW_PRIORITY")) {
                writer.append("/* " + priority + "*/").writeSpace(1);
            } else {
                writer.append(sqlNode.getDuplicationPriority().toString()).writeSpace(1);
            }
        }
    }

    private void duplicate(SqlInsertReplaceStatement sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("table.insert.convert.upsert");
        if (sqlNode.isHavingDuplicate()) {
            writer.append("ON").writeSpace(1).append("DUPLICATE").writeSpace(1).append("KEY").writeSpace(1).append("UPDATE").writeSpace(1);
            List<SqlUpdatedElement> sqlUpdatedElements = sqlNode.getSqlDuplicateUpdatedElement().getNodes();
            for (int j = 0; j < sqlUpdatedElements.size(); ++j) {
                if (sqlUpdatedElements.get(j).getSqlExpression() != null) {
                    sqlUpdatedElements.get(j).unparse(writer, context);
                }
                if (j == sqlUpdatedElements.size() - 1) continue;
                writer.append(", ");
            }
        }
        if (ConfigUtil.getConfigValue(config, "table.insert.convert.upsert", "false").equalsIgnoreCase("true") && sqlNode.getParameterList() != null) {
            writer.append("ON").writeSpace(1).append("DUPLICATE").writeSpace(1).append("KEY").writeSpace(1).append("UPDATE").writeSpace(1);
            for (int i = 0; i < sqlNode.getParameterList().getNodes().size(); ++i) {
                String columnName = sqlNode.getParameterList().getNodes().get(i).getNames().getNodes().get(0).getIdentifier();
                writer.append(columnName).append(" = ").append("EXCLUDED.").append(columnName);
                if (i == sqlNode.getParameterList().getNodes().size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
        }
    }

    private void unparseValuesContent(SqlWriter writer, SqlNodeList<SqlUpdatedElement> row, UnParserContext context) {
        for (int j = 0; j < row.getNodes().size(); ++j) {
            if (row.getNodes().get(j).isUseDefault()) {
                writer.append("DEFAULT");
            } else {
                row.getNodes().get(j).getSqlExpression().unparse(writer, context);
                if (writer.toSqlString().getSql().contains("POINT")) {
                    LOGGER.error("The type point is not supported in DSC");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "The type point.");
                }
                if (writer.toSqlString().getSql().contains("LINESTRING")) {
                    LOGGER.error("The type linestring is not supported in DSC");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "The type linestring");
                }
            }
            if (j == row.getNodes().size() - 1) continue;
            writer.append(",");
        }
    }
}

