/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlKeysTypeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlKeysTypeOptions.class)
public class SqlKeysTypeOptionsUnParser
implements UnParser<SqlKeysTypeOptions> {
    private static final Logger LOGGER = LogManager.getLogger(SqlKeysTypeOptionsUnParser.class);

    @Override
    public void unparse(SqlKeysTypeOptions sqlKeysTypeOptions, SqlWriter writer, UnParserContext context) {
        SqlTableName sqlTableName = sqlKeysTypeOptions.getTableName();
        if (sqlTableName == null) {
            LOGGER.error("Can not found table name when create index.");
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Can not found table name when create index.");
        }
        if ("PRIMARY".equalsIgnoreCase(sqlKeysTypeOptions.getKeyWord())) {
            this.addPrimaryKey(sqlKeysTypeOptions, sqlTableName, writer, context);
        } else {
            this.addIndex(sqlKeysTypeOptions, sqlTableName, writer, context);
        }
    }

    private void addIndex(SqlKeysTypeOptions sqlKeysTypeOptions, SqlTableName sqlTableName, SqlWriter writer, UnParserContext context) {
        if ("UNIQUE".equalsIgnoreCase(sqlKeysTypeOptions.getKeyWord())) {
            writer.append("CREATE UNIQUE INDEX");
        } else {
            writer.append("CREATE INDEX");
        }
        SqlIdentifier sqlIndexName = sqlKeysTypeOptions.getConstructedIndexName(writer, context);
        writer.writeSpace(1);
        sqlIndexName.unparse(writer, context);
        writer.writeSpace(1).append("ON").writeSpace(1);
        sqlTableName.unparse(writer, context);
        this.writerKeyColumns(sqlKeysTypeOptions, writer);
        if (sqlKeysTypeOptions.isPartition()) {
            writer.writeSpace(1).append("local");
        }
        writer.sqlEnd();
    }

    private void addPrimaryKey(SqlKeysTypeOptions sqlKeysTypeOptions, SqlTableName sqlTableName, SqlWriter writer, UnParserContext context) {
        writer.append("ALTER TABLE ");
        sqlTableName.unparse(writer, context);
        writer.writeSpace(1);
        writer.append("ADD PRIMARY KEY");
        this.writerKeyColumns(sqlKeysTypeOptions, writer);
        writer.sqlEnd();
    }

    private void writerKeyColumns(SqlKeysTypeOptions sqlKeysTypeOptions, SqlWriter writer) {
        writer.writeSpace(1);
        writer.append("(");
        writer.append(sqlKeysTypeOptions.getUidList().stream().map(uid -> QuoteUtils.addDoubleQuote(QuoteUtils.removeQuote(uid))).collect(Collectors.joining(",")));
        writer.append(")");
    }
}

