/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlInsertReplaceStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockTableElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockTables;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlLockTables.class)
public class SqlLockTableUnParser
implements UnParser<SqlLockTables> {
    private static final Logger LOGGER = LogManager.getLogger(SqlInsertReplaceStatement.class);
    private Set<String> tableName = new HashSet<String>();

    @Override
    public void unparse(SqlLockTables lockTable, SqlWriter writer, UnParserContext context) {
        LOGGER.info("SqlLockTable unparse enter");
        if (lockTable.isUnlock()) {
            return;
        }
        List<SqlLockTableElement> tableElements = lockTable.getSqlLockTableElement().getNodes();
        for (int index = 1; index <= tableElements.size(); ++index) {
            String strTableName = tableElements.get(index - 1).getTableName().getTableName().getIdentifier();
            if (this.tableName.contains(strTableName)) continue;
            this.tableName.add(strTableName);
            writer.append("LOCK").writeSpace(1).append("TABLE").writeSpace(1);
            tableElements.get(index - 1).unparse(writer, context);
            if (index == tableElements.size() || tableElements.get(index).getTableNameAlias() != null) continue;
            writer.sqlEnd().newLine();
        }
        writer.sqlEnd();
        LOGGER.info("SqlLockUnParser result: {}", (Object)writer.toSqlString());
    }
}

