/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinition;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlPartitionDefinition.class)
public class SqlPartitionDefinitionUnParser
implements UnParser<SqlPartitionDefinition> {
    private static final Logger LOGGER = LogManager.getLogger(SqlPartitionDefinitionUnParser.class);

    @Override
    public void unparse(SqlPartitionDefinition partitionDefinition, SqlWriter writer, UnParserContext context) {
        writer.append("PARTITION").writeSpace(1);
        String str = partitionDefinition.getUid().getValue().toString();
        str = QuoteUtils.removeQuote(str);
        writer.append(str);
        writer.writeSpace(1);
        switch (partitionDefinition.getDefinition()) {
            case COMPARISION: {
                writer.append("VALUES").writeSpace(1).append("LESS").writeSpace(1).append("THAN").writeSpace(1);
                writer.append("(");
                context.setNodeListSeparator(", ");
                partitionDefinition.getPartitionDefinerAtom().unparse(writer, context);
                writer.append(")");
                this.getOptionAndSubFun(partitionDefinition, writer, context);
                break;
            }
            case LIST_ATOM: {
                writer.append("VALUES").writeSpace(1);
                writer.append("(");
                context.setNodeListSeparator(", ");
                partitionDefinition.getPartitionDefinerAtom().unparse(writer, context);
                writer.append(")");
                break;
            }
            case LIST_VECTOR: 
            case SIMPLE: {
                LOGGER.error("No Support the type of partitioning message.");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "LIST_VECTOR | SIMPLE");
            }
            case FIXED_RANGE: {
                writer.append("VALUES LESS THAN").writeSpace(1);
                writer.append("(");
                context.setNodeListSeparator(", ");
                partitionDefinition.getPartitionDefinerAtomEnd().unparse(writer, context);
                writer.append(")");
                break;
            }
        }
    }

    private void getOptionAndSubFun(SqlPartitionDefinition partitionDefinition, SqlWriter writer, UnParserContext context) {
        if (partitionDefinition.getPartitionOption() != null && !partitionDefinition.getPartitionOption().getNodes().isEmpty()) {
            writer.writeSpace(1);
            context.setNodeListSeparator("");
            partitionDefinition.getPartitionOption().unparse(writer, context);
            context.resetNodeListSeparator();
        }
        if (partitionDefinition.getSubpartitionDefinition() != null && !partitionDefinition.getSubpartitionDefinition().getNodes().isEmpty()) {
            LOGGER.error("Subpartition is not supported in DSC");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Subpartition");
        }
    }
}

