/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinitions;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlPartitionDefinitions.class)
public class SqlPartitionDefinitionsUnParser
implements UnParser<SqlPartitionDefinitions> {
    @Override
    public void unparse(SqlPartitionDefinitions partitionDefinitions, SqlWriter writer, UnParserContext context) {
        String partitionCommentEnable;
        boolean isSupPartition = true;
        if (partitionDefinitions.getPartitionFunctionDefinition() != null) {
            SqlPartitionFunctionDefinition.PartitionFunction partitionFunction = partitionDefinitions.getPartitionFunctionDefinition().getPartitionFunction();
            switch (partitionFunction) {
                case LIST: 
                case RANGE: 
                case PERIOD: {
                    writer.newLine().append("PARTITION BY ");
                    partitionDefinitions.getPartitionFunctionDefinition().unparse(writer, context);
                    writer.newLine();
                    break;
                }
                case VALUE: {
                    writer.newLine().append("PARTITION BY ");
                    partitionDefinitions.getPartitionFunctionDefinition().unparse(writer, context);
                    break;
                }
                case KEY: 
                case HASH: 
                case HASH_KEY: {
                    isSupPartition = false;
                    writer.newLine().append("/* PARTITION BY ");
                    partitionDefinitions.getPartitionFunctionDefinition().unparse(writer, context);
                    break;
                }
            }
        }
        if (partitionDefinitions.getCount() != null) {
            writer.newLine();
            SqlWriter oriWriter = writer.cloneEmpty();
            oriWriter.append(partitionDefinitions.getPartitions()).writeSpace(1);
            oriWriter.append(partitionDefinitions.getCount());
            this.commentPartitionByArg(isSupPartition, writer, oriWriter);
        }
        if (partitionDefinitions.getSubPartitionFunctionDefinition() != null) {
            writer.newLine();
            SqlWriter subWriter = writer.cloneEmpty();
            this.mergeSubPartitionContent(partitionDefinitions, subWriter, context);
            this.commentPartitionByArg(isSupPartition, writer, subWriter);
        }
        if (partitionDefinitions.getPartitionDefinition() != null && !partitionDefinitions.getPartitionDefinition().getNodes().isEmpty()) {
            writer.append("(");
            SqlNodeList<SqlPartitionDefinition> definitionList = partitionDefinitions.getPartitionDefinition();
            for (int i = 0; i < definitionList.getNodes().size(); ++i) {
                writer.newLine();
                writer.indentation(1);
                definitionList.getNodes().get(i).unparse(writer, context);
                if (i == definitionList.getNodes().size() - 1) continue;
                writer.append(",");
            }
            writer.newLine().append(")");
        }
        if (!isSupPartition) {
            writer.append(" */");
        }
        if ("true".equals(partitionCommentEnable = context.getConfigValue(writer, "table.partition.comment.enable", "false"))) {
            writer.append("/* ").append(partitionDefinitions.getOriginPartitionSql()).append(" */");
        }
    }

    private void mergeSubPartitionContent(SqlPartitionDefinitions partitionDefinitions, SqlWriter writer, UnParserContext context) {
        if (partitionDefinitions.getSubPartitionFunctionDefinition() != null) {
            writer.append("SUBPARTITION BY").writeSpace(1);
            partitionDefinitions.getSubPartitionFunctionDefinition().unparse(writer, context);
        }
        if (partitionDefinitions.getSubCount() != null) {
            writer.newLine().append("SUBPARTITIONS ").append(partitionDefinitions.getSubCount());
        } else if (partitionDefinitions.getSubCountAdb() != null) {
            writer.newLine().append("SUBPARTITION OPTIONS (").append("AVAILABLE_PARTITION_NUM").append(" = ");
            writer.append(partitionDefinitions.getSubCountAdb()).append(")");
        }
    }

    private void commentPartitionByArg(boolean isSupPartition, SqlWriter sqlWriter, SqlWriter oriWriter) {
        if (isSupPartition) {
            sqlWriter.append("/* ");
        }
        sqlWriter.append(oriWriter.toSqlString().getSql());
        if (isSupPartition) {
            sqlWriter.append(" */");
        }
    }
}

