/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlQuerySpecification;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlQuerySpecification.class)
public class SqlQuerySpecificationUnParser
implements UnParser<SqlQuerySpecification> {
    private static final Logger LOGGER = LogManager.getLogger(SqlQuerySpecificationUnParser.class);

    @Override
    public void unparse(SqlQuerySpecification sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTableStatement() != null) {
            sqlNode.getTableStatement().unparse(writer, context);
        } else {
            if (sqlNode.isIfHaveLBracket()) {
                writer.append("( ");
            }
            writer.append("SELECT").writeSpace(1);
            if (sqlNode.getHint() != null) {
                for (int i = 0; i < sqlNode.getHint().size(); ++i) {
                    writer.append(sqlNode.getHint().get(i)).writeSpace(1);
                }
            }
            if (sqlNode.getSelectSpec() != null) {
                boolean priorityTwo;
                String priority = sqlNode.getSelectSpec().toUpperCase(Locale.ROOT);
                boolean priorityOne = priority.contains("SQL_NO_CACHE") || priority.contains("SQL_CACHE") || priority.contains("SQL_CALC_FOUND_ROWS");
                boolean bl = priorityTwo = priority.contains("SQL_BUFFER_RESULT") || priority.contains("SQL_BIG_RESULT") || priority.contains("SQL_SMALL_RESULT");
                if (priority.contains("HIGH_PRIORITY") || priority.contains("STRAIGHT_JOIN")) {
                    writer.append("/* " + priority + "*/").writeSpace(1);
                } else if (priority.contains("DISTINCTROW")) {
                    writer.append("DISTINCT");
                } else {
                    if (priorityOne || priorityTwo) {
                        LOGGER.error("The conversion is not supported in DWS");
                        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "select spec " + priority);
                    }
                    writer.append(priority);
                }
                writer.writeSpace(1);
            }
            if (sqlNode.getSqlSelectElements() != null) {
                sqlNode.getSqlSelectElements().unparse(writer, context);
            }
            if (sqlNode.getSqlFromClause() != null) {
                sqlNode.getSqlFromClause().unparse(writer, context);
            }
            if (sqlNode.isIfHaveRBracket()) {
                writer.append(") ");
            }
            if (sqlNode.getSqlGroupByClause() != null) {
                sqlNode.getSqlGroupByClause().unparse(writer, context);
            }
            if (sqlNode.getSqlHavingClause() != null) {
                sqlNode.getSqlHavingClause().unparse(writer, context);
            }
            if (sqlNode.getSqlWindowClause() != null) {
                sqlNode.getSqlWindowClause().unparse(writer, context);
            }
            if (sqlNode.getSqlOrderByClause() != null) {
                sqlNode.getSqlOrderByClause().unparse(writer, context);
            }
            if (sqlNode.getSqlLimitClause() != null) {
                sqlNode.getSqlLimitClause().unparse(writer, context);
            }
        }
    }
}

