/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlNewValueInsideTrigger;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetNewValueInsideTrigger;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetNewValueInsideTrigger.class)
public class SqlSetNewValueInsideTriggerUnParser
implements UnParser<SqlSetNewValueInsideTrigger> {
    private static final Logger LOGGER = LogManager.getLogger(SqlSetNewValueInsideTriggerUnParser.class);

    @Override
    public void unparse(SqlSetNewValueInsideTrigger sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "sql.conversion.type", "ddl").equalsIgnoreCase("plsql")) {
            LOGGER.error("Not supported set new value inside trigger");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "set @name= in plsql");
        }
        writer.append("SET").writeSpace(1);
        SqlNodeList<SqlNewValueInsideTrigger> sqlNewValueInsideTriggers = sqlNode.getSqlNewValueInsideTriggers();
        for (int i = 0; i < sqlNewValueInsideTriggers.getNodes().size(); ++i) {
            writer.append(sqlNewValueInsideTriggers.getNodes().get(i).getFullId()).writeSpace(1);
            writer.append("=").writeSpace(1);
            sqlNewValueInsideTriggers.getNodes().get(i).getSqlExpression().unparse(writer, context);
            if (i == sqlNewValueInsideTriggers.getNodes().size() - 1) continue;
            writer.append(";").writeSpace(1);
        }
        writer.sqlEnd();
    }
}

