/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetPasswordStatement;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetPasswordStatement.class)
public class SqlSetPasswordStatementUnParser
implements UnParser<SqlSetPasswordStatement> {
    private static final Logger LOGGER = LogManager.getLogger(SqlSetPasswordStatementUnParser.class);

    @Override
    public void unparse(SqlSetPasswordStatement sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "table.sql.set.password", "true").equalsIgnoreCase("false")) {
            LOGGER.error("Not supported set password statement");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "set password");
        }
        this.setPasswordChange(sqlNode, writer, context);
    }

    private void setPasswordChange(SqlSetPasswordStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("SET").writeSpace(1).append("PASSWORD").writeSpace(1);
        if (sqlNode.getUserName() != null) {
            writer.append("FOR").writeSpace(1).append(sqlNode.getUserName()).writeSpace(1);
        }
        writer.append("=").writeSpace(1);
        if (sqlNode.getPasswordFunctionClause() != null) {
            writer.append(sqlNode.getPasswordFunctionClause().getFunctionName()).writeSpace(1);
            writer.append("(");
            sqlNode.getPasswordFunctionClause().getFunctionArg().unparse(writer, context);
            writer.append(")");
        } else {
            writer.append(sqlNode.getStringLiteral());
        }
        writer.sqlEnd();
    }
}

