/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetResourceGroup;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetResourceGroup.class)
public class SqlSetResourceGroupUnParser
implements UnParser<SqlSetResourceGroup> {
    private static final Logger LOGGER = LogManager.getLogger(SqlSetResourceGroupUnParser.class);

    @Override
    public void unparse(SqlSetResourceGroup sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "table.sql.set.resource.group", "true").equalsIgnoreCase("false")) {
            LOGGER.error("Not supported set resource group statement");
            throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "Set resource group statement", " set resource group");
        }
        this.setResourceGroupChange(sqlNode, writer);
    }

    private void setResourceGroupChange(SqlSetResourceGroup sqlNode, SqlWriter writer) {
        writer.append("SET").writeSpace(1).append("RESOURCE").writeSpace(1).append("GROUP").writeSpace(1);
        if (sqlNode.getGroupName() != null) {
            writer.append(sqlNode.getGroupName());
        }
        if (sqlNode.getConstants() != null) {
            writer.writeSpace(1).append("FOR").writeSpace(1);
            for (int i = 0; i < sqlNode.getConstants().size(); ++i) {
                writer.append(sqlNode.getConstants().get(i));
                if (i == sqlNode.getConstants().size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
        }
        writer.sqlEnd();
    }
}

