/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetVariable;
import com.huawei.hwclouds.scs.sql.nodes.SqlVariableClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlVariableStatement;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetVariable.class)
public class SqlSetVariableUnParser
implements UnParser<SqlSetVariable> {
    @Override
    public void unparse(SqlSetVariable sqlNode, SqlWriter writer, UnParserContext context) {
        List<SqlVariableStatement> sqlVariableClauseList;
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "sql.conversion.type", "ddl").equalsIgnoreCase("plsql")) {
            if (!ConfigUtil.getConfigValue(config, "table.sql.set.variable", "true").equalsIgnoreCase("false")) {
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "SET VARIABLE");
            }
            this.setVariableChange(sqlNode, writer, context);
        } else if (sqlNode.isOnlyUid() && (sqlVariableClauseList = sqlNode.getSqlVariableClauseList()) != null) {
            writer.append("SET").writeSpace(1);
            for (int i = 0; i < sqlVariableClauseList.size(); ++i) {
                SqlVariableClause sqlVariableClause = sqlVariableClauseList.get(i).getSqlVariableClause();
                writer.append(sqlVariableClause.getUid()).writeSpace(1);
                if (sqlVariableClauseList.get(i).isEqualSymbol()) {
                    writer.append(":=").writeSpace(1);
                }
                if (sqlVariableClauseList.get(i).getSqlExpression() != null) {
                    sqlVariableClauseList.get(i).getSqlExpression().unparse(writer, context);
                }
                writer.sqlEnd();
            }
        }
    }

    private void setVariableChange(SqlSetVariable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("SET").writeSpace(1);
        List<SqlVariableStatement> sqlVariableClauseList = sqlNode.getSqlVariableClauseList();
        if (sqlVariableClauseList != null) {
            for (int i = 0; i < sqlVariableClauseList.size(); ++i) {
                SqlVariableClause sqlVariableClause = sqlVariableClauseList.get(i).getSqlVariableClause();
                if (sqlVariableClause.getGlobalId() != null) {
                    writer.append(sqlVariableClause.getGlobalId()).writeSpace(1);
                } else if (sqlVariableClause.getLocalId() != null) {
                    writer.append(sqlVariableClause.getLocalId()).writeSpace(1);
                } else if (sqlVariableClause.getUid() != null) {
                    if (sqlVariableClause.getSystemVariable() != null) {
                        if (sqlVariableClause.getAtSign() != null) {
                            writer.append("@@").writeSpace(1);
                        }
                        writer.append(sqlVariableClause.getSystemVariable());
                        writer.writeSpace(1);
                    }
                    writer.append(sqlVariableClause.getUid()).writeSpace(1);
                }
                if (sqlVariableClauseList.get(i).isEqualSymbol()) {
                    writer.append("=").writeSpace(1);
                } else {
                    writer.append(":=").writeSpace(1);
                }
                if (sqlVariableClauseList.get(i).getSqlExpression() != null) {
                    sqlVariableClauseList.get(i).getSqlExpression().unparse(writer, context);
                } else {
                    writer.append(sqlVariableClauseList.get(i).getIsHavingOn());
                }
                if (i == sqlVariableClauseList.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
        }
        writer.sqlEnd();
    }
}

