/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSubPartitionFunctionDefinition.class)
public class SqlSubPartitionFunctionDefinitionUnParser
implements UnParser<SqlSubPartitionFunctionDefinition> {
    @Override
    public void unparse(SqlSubPartitionFunctionDefinition subPartitionFunction, SqlWriter writer, UnParserContext context) {
        if (subPartitionFunction.getSubPartitionFunction() != null) {
            switch (subPartitionFunction.getSubPartitionFunction()) {
                case HASH: {
                    if (subPartitionFunction.isLinear()) {
                        writer.append("LINEAR").writeSpace(1);
                    }
                    writer.append("HASH (").append(subPartitionFunction.getExpression()).append(")");
                    break;
                }
                case KEY: {
                    if (subPartitionFunction.isLinear()) {
                        writer.append("LINEAR").writeSpace(1);
                    }
                    writer.append("KEY").writeSpace(1);
                    if (subPartitionFunction.getAlgorithm() != null) {
                        writer.append("ALGORITHM = ").append(subPartitionFunction.getAlgorithm());
                    }
                    writer.append("(");
                    List<SqlIdentifier> columnNames = subPartitionFunction.getColumnName().getNodes();
                    for (int i = 0; i < columnNames.size(); ++i) {
                        writer.append(columnNames.get(i).getIdentifier());
                        if (i == columnNames.size() - 1) continue;
                        writer.append(", ");
                    }
                    writer.append(")");
                    break;
                }
                case LIST: {
                    writer.append("LIST").writeSpace(1);
                    if (subPartitionFunction.isLong()) {
                        writer.append("(").append(subPartitionFunction.getFullColumnName()).append(" LONG)");
                        break;
                    }
                    writer.append("KEY").append("(").append(subPartitionFunction.getFullColumnName()).append(")");
                    break;
                }
            }
        }
    }
}

