/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlTableName.class)
public class SqlTableNameUnParser
implements UnParser<SqlTableName> {
    @Override
    public void unparse(SqlTableName sqlTableName, SqlWriter writer, UnParserContext context) {
        ConvertConfig nameConfig = writer.getConfig("param.config.flag");
        String configValue = ConfigUtil.getConfigValue(nameConfig, "table.origin.database.type", "mysql");
        if (configValue.equalsIgnoreCase("bigquery") || configValue.equalsIgnoreCase("synapse") || configValue.equalsIgnoreCase("sqlserver")) {
            if (sqlTableName.getDatabaseName() != null && sqlTableName.getSchemaName() != null && sqlTableName.getTableName() != null) {
                new SqlIdentifier(sqlTableName.getSchemaName().getIdentifier()).unparse(writer, context);
                writer.append(".");
                new SqlIdentifier(sqlTableName.getTableName().getIdentifier()).unparse(writer, context);
                return;
            }
            if (sqlTableName.getDatabaseName() != null && sqlTableName.getTableName() != null) {
                new SqlIdentifier(sqlTableName.getDatabaseName().getIdentifier()).unparse(writer, context);
                writer.append(".");
                new SqlIdentifier(sqlTableName.getTableName().getIdentifier()).unparse(writer, context);
                return;
            }
            if (sqlTableName.getTableName() != null) {
                sqlTableName.getTableName().unparse(writer, context);
                return;
            }
        }
        if (sqlTableName.isTemporaryTable()) {
            sqlTableName.getTableName().unparse(writer, context);
            return;
        }
        ConvertConfig config = writer.getConfig(sqlTableName.getTableName().getIdentifier());
        String confSchema = ConfigUtil.getConfigValue(config, "table.schema", null);
        String confDefaultSchema = ConfigUtil.getConfigValue(config, "table.defaultSchema", null);
        if (confSchema != null && !confSchema.isEmpty()) {
            new SqlIdentifier(confSchema).unparse(writer, context);
            writer.append(".");
        } else if (ConfigUtil.getConfigValue(config, "table.databaseAsSchema", "true").equalsIgnoreCase("true")) {
            if (sqlTableName.getDatabaseName() != null) {
                sqlTableName.getDatabaseName().unparse(writer, context);
                writer.append(".");
            } else if (context.isOriSchema()) {
                String schemaNameValue = PropertyLoader.getStringProperty(MysqlPropEnum.SCHEMA_NAME.getValue());
                if (!schemaNameValue.equals("ori") && !confDefaultSchema.isEmpty()) {
                    new SqlIdentifier(confDefaultSchema).unparse(writer, context);
                    writer.append(".");
                }
            } else if (!confDefaultSchema.isEmpty()) {
                new SqlIdentifier(confDefaultSchema).unparse(writer, context);
                writer.append(".");
            }
        } else if (!confDefaultSchema.isEmpty()) {
            new SqlIdentifier(confDefaultSchema).unparse(writer, context);
            writer.append(".");
        }
        sqlTableName.getTableName().unparse(writer, context);
    }
}

