/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionRowFormat;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlTableOptionRowFormat.class, Unsupported=false)
public class SqlTableOptionRowFormatUnParser
implements UnParser<SqlTableOptionRowFormat> {
    private static final Logger LOGGER = LogManager.getLogger(SqlTableOptionRowFormat.class);

    @Override
    public void unparse(SqlTableOptionRowFormat sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig(sqlNode.getTableName().getTableName().getIdentifier());
        if (!ConfigUtil.getConfigValue(config, "table.orientation", "ROW").equalsIgnoreCase("ROW")) {
            LOGGER.info("column-store relation doesn't support this ALTER yet");
            return;
        }
        switch (sqlNode.getRowFormat()) {
            case FIXED: 
            case DYNAMIC: 
            case COMPACT: 
            case IXED: 
            case REDUNDANT: {
                break;
            }
            case DEFAULT: {
                writer.writeSpace(1);
                writer.append("SET");
                writer.writeSpace(1);
                writer.append("NOCOMPRESS");
                break;
            }
            case COMPRESSED: {
                writer.writeSpace(1);
                writer.append("SET");
                writer.writeSpace(1);
                writer.append("COMPRESS");
                break;
            }
            default: {
                LOGGER.error("Other row_format options are not supported in DSC");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "row format option " + (Object)((Object)sqlNode.getRowFormat()));
            }
        }
    }
}

