/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSourceItem;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlTableSourceItem.class)
public class SqlTableSourceItemUnParser
implements UnParser<SqlTableSourceItem> {
    @Override
    public void unparse(SqlTableSourceItem sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig bigqeuryConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery") && sqlNode.getTableName() != null && sqlNode.getTableName().split("\\.").length == 3) {
            String tableName = sqlNode.getTableName().substring(sqlNode.getTableName().indexOf(".") + 1, sqlNode.getTableName().length() - 1);
            sqlNode.setTableName(tableName);
        }
        if ("doris".equalsIgnoreCase(ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql")) && sqlNode.getTableName() != null && sqlNode.getTableName().split("\\.").length == 2) {
            String[] split = sqlNode.getTableName().split("\\.");
            String schemaName = QuoteUtils.removeQuote(split[0]).trim();
            String tableName = QuoteUtils.removeQuote(split[1]).trim();
            schemaName = schemaName.replace("default_cluster:", "").trim();
            sqlNode.setTableName(QuoteUtils.addDoubleQuote(schemaName) + "." + QuoteUtils.addDoubleQuote(tableName));
        }
        if (sqlNode.getTableName() != null) {
            writer.append(QuoteUtils.addDoubleQuoteForDigitField(sqlNode.getTableName())).writeSpace(1);
            if (sqlNode.getPartitionUidList() != null) {
                String content = writer.toSqlString().getSql();
                for (int i = 0; i < sqlNode.getPartitionUidList().size(); ++i) {
                    if (sqlNode.getPartitionUidList().size() < 1) continue;
                    writer.append("PARTITION").writeSpace(1).append("(");
                    writer.append(sqlNode.getPartitionUidList().get(i)).writeSpace(1);
                    writer.append(")");
                    if (i == sqlNode.getPartitionUidList().size() - 1) continue;
                    writer.newLine().append("UNION ALL").newLine();
                    writer.append(content);
                }
            }
        }
        if (sqlNode.getSqlSelectStatement() != null) {
            if (sqlNode.isBrackets()) {
                writer.writeSpace(1).append("(").writeSpace(1);
                sqlNode.getSqlSelectStatement().unparse(writer, context);
                writer.writeSpace(1).append(")").writeSpace(1);
            } else {
                sqlNode.getSqlSelectStatement().unparse(writer, context);
            }
        }
        if (sqlNode.isIfHaveAs()) {
            writer.append("AS").writeSpace(1);
        }
        if (sqlNode.getUid() != null) {
            writer.append(QuoteUtils.changeQuoteToDouble(sqlNode.getUid())).writeSpace(1);
        }
        if (sqlNode.getSqlIndexHintSqlNodeList() != null) {
            for (int i = 0; i < sqlNode.getSqlIndexHintSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getSqlIndexHintSqlNodeList().getNodes().get(i).unparse(writer, context);
            }
        }
        if (sqlNode.getTableSources() != null) {
            writer.append("(").writeSpace(1);
            sqlNode.getTableSources().unparse(writer, context);
            writer.append(")").writeSpace(1);
        }
    }
}

