/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlTransactionOption;
import com.huawei.hwclouds.scs.sql.nodes.TransactionMode;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlTransactionOption.class)
public class SqlTransactionOptionUnParser
implements UnParser<SqlTransactionOption> {
    private static final Logger LOGGER = LogManager.getLogger(SqlTransactionOptionUnParser.class);

    @Override
    public void unparse(SqlTransactionOption transationOption, SqlWriter writer, UnParserContext context) {
        if (transationOption.getTransactionMode() != null && !transationOption.getTransactionMode().isEmpty()) {
            writer.writeSpace(1).append("ISOLATION").writeSpace(1).append("LEVEL").writeSpace(1);
            block6: for (TransactionMode mode : transationOption.getTransactionMode()) {
                switch (mode) {
                    case REPEATABLE_READ: {
                        writer.append("REPEATABLE").writeSpace(1).append("READ");
                        continue block6;
                    }
                    case READ_COMMITTED: {
                        writer.append("READ").writeSpace(1).append("COMMITTED");
                        continue block6;
                    }
                    case READ_UNCOMMITTED: {
                        writer.append("READ").writeSpace(1).append("UNCOMMITTED");
                        continue block6;
                    }
                    case SERIALIZABLE: {
                        writer.append("SERIALIZABLE");
                        continue block6;
                    }
                }
                LOGGER.error("Unrecognized isolation level : " + (Object)((Object)mode));
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Unrecognized isolation level : " + (Object)((Object)mode));
            }
        }
        if (transationOption.getAccessMode() != null) {
            writer.writeSpace(1).append("READ").writeSpace(1);
            if (transationOption.getAccessMode().equals((Object)SqlTransactionOption.AccessMode.READ_ONLY)) {
                writer.append("ONLY");
            }
            if (transationOption.getAccessMode().equals((Object)SqlTransactionOption.AccessMode.READ_WRITE)) {
                writer.append("WRITE");
            }
        }
    }
}

