/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.util;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlCaseFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlGroupByItem;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColumnUtil {
    private static final Pattern DATE_PAT = Pattern.compile("^([\\d]{4}-[\\d]{1,2}-[\\d]{1,2})([+-].*)$");

    public static String getFullColumnName(String fullColumn) {
        String[] columnSplit = fullColumn.split("\\.");
        if (columnSplit.length == 1) {
            return QuoteUtils.addDoubleQuoteForDigitField(columnSplit[0]);
        }
        if (columnSplit.length != 2) {
            return fullColumn;
        }
        String tableName = QuoteUtils.addDoubleQuoteForDigitField(columnSplit[0]);
        String columnName = QuoteUtils.replaceSingleToDoubleQuote(columnSplit[1]);
        columnName = QuoteUtils.addDoubleQuoteForDigitField(columnName);
        return tableName + "." + columnName;
    }

    public static String getDefaultValue(SqlDataTypeSpec dataTypeSpec, SqlLiteral defaultValue) {
        Matcher dateMatch;
        String defaultVal = defaultValue.getValue().toString();
        if (dataTypeSpec.getTypeName() != null && dataTypeSpec.getTypeName().equals((Object)SqlTypeName.DATE) && (dateMatch = DATE_PAT.matcher(defaultVal)).matches()) {
            String date = dateMatch.group(1);
            String other = dateMatch.group(2);
            defaultVal = other.trim().equals("") ? date : date + " " + other.trim();
        }
        return QuoteUtils.addSingleQuote(QuoteUtils.removeAllQuoteForField(defaultVal));
    }

    public static void fullGroupByArgs(SqlNodeList<SqlSelectElement> selectElementSqlNodeList, List<SqlGroupByItem> sqlGroupByItems, SqlWriter writer, UnParserContext context, UnParser unParser) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        boolean isFullGroupBy = ConfigUtil.getConfigValue(config, "table.database.onlyFullGroupBy", "false").equalsIgnoreCase("true");
        ArrayList<SqlGroupByItem> sqlGroupByItemList = new ArrayList<SqlGroupByItem>();
        for (int i = 0; i < sqlGroupByItems.size(); ++i) {
            SqlGroupByItem sqlGroupByItem = sqlGroupByItems.get(i);
            if (isFullGroupBy) {
                sqlGroupByItemList.add(sqlGroupByItem);
            }
            sqlGroupByItem.unparse(writer, context);
            if (i != sqlGroupByItems.size() - 1) {
                writer.append(", ");
            } else {
                writer.writeSpace(1);
            }
            unParser.unparseComment(sqlGroupByItem, writer);
        }
        if (isFullGroupBy) {
            ArrayList<Integer> subscriptList = new ArrayList<Integer>();
            if (selectElementSqlNodeList != null) {
                List<SqlSelectElement> sqlSelectElements = selectElementSqlNodeList.getNodes();
                for (int i = 0; i < sqlSelectElements.size(); ++i) {
                    SqlSelectElement sqlSelectElement = sqlSelectElements.get(i);
                    SqlWriter sqlWriter = writer.cloneEmpty();
                    selectElementSqlNodeList.getNodes().get(i).unparse(sqlWriter, context);
                    String sql = sqlWriter.toSqlString().getSql();
                    String reg = "[\\S+\\s+]*(sum|count|max|min|avg|group_concat)\\s*\\(.*";
                    Pattern pattern = Pattern.compile(reg, 2);
                    if (pattern.matcher(sql).matches()) continue;
                    ColumnUtil.checkFunctionElement(sqlGroupByItemList, subscriptList, i, sqlSelectElement, sql);
                    ColumnUtil.checkColumnElement(sqlGroupByItemList, subscriptList, sqlSelectElements, i, sqlSelectElement);
                }
            }
            for (int i = 0; i < subscriptList.size(); ++i) {
                writer.append(",").writeSpace(1).append(String.valueOf(subscriptList.get(i)));
            }
        }
    }

    private static void checkColumnElement(List<SqlGroupByItem> sqlGroupByItemList, List<Integer> subscriptList, List<SqlSelectElement> sqlSelectElements, Integer i, SqlSelectElement sqlSelectElement) {
        if (sqlSelectElement.getSqlSelectColumnElement() != null) {
            boolean columnElement = false;
            for (int j = 0; j < sqlGroupByItemList.size(); ++j) {
                String selectElementFullColumnName;
                SqlExpressionAtom sqlExpressionAtom = sqlGroupByItemList.get(j).getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom();
                if (sqlExpressionAtom.getSqlConstantExpressionAtom() != null) {
                    String literal = sqlExpressionAtom.getSqlConstantExpressionAtom().getLiteral().getLiteral();
                    if (Integer.parseInt(literal) == i + 1) {
                        columnElement = false;
                        break;
                    }
                    columnElement = true;
                }
                if (sqlExpressionAtom.getFullColumnName() == null) continue;
                String groupByItemFullColumnName = sqlExpressionAtom.getFullColumnName();
                if (groupByItemFullColumnName.equals(selectElementFullColumnName = sqlSelectElements.get(i).getSqlSelectColumnElement().getFullColumnName())) {
                    columnElement = false;
                    break;
                }
                columnElement = true;
            }
            if (columnElement) {
                subscriptList.add(i + 1);
            }
        }
    }

    private static void checkFunctionElement(List<SqlGroupByItem> sqlGroupByItemList, List<Integer> subscriptList, Integer i, SqlSelectElement sqlSelectElement, String sql) {
        if (sqlSelectElement.getSqlSelectFunctionElement() != null) {
            SqlFunctionCall sqlFunctionCall = sqlSelectElement.getSqlSelectFunctionElement().getSqlFunctionCall();
            if (sqlFunctionCall.getSqlSpecificFunctionCall() != null) {
                SqlCaseFunctionCall caseAndExpressionFunction = sqlFunctionCall.getSqlSpecificFunctionCall().getSqlSpecificFunction().getCaseAndExpressionFunction();
                if (caseAndExpressionFunction != null) {
                    boolean otherFunction = false;
                    for (int j = 0; j < sqlGroupByItemList.size(); ++j) {
                        String selectElementFullColumnName;
                        SqlExpressionAtom sqlExpressionAtom = sqlGroupByItemList.get(j).getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom();
                        if (sqlExpressionAtom.getSqlFunctionCallExpressionAtom() == null) continue;
                        String groupByItemFullColumnName = sqlExpressionAtom.getSqlFunctionCallExpressionAtom().getSqlFunctionCall().getSqlSpecificFunctionCall().getSqlSpecificFunction().getCaseAndExpressionFunction().getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom().getFullColumnName();
                        if (groupByItemFullColumnName.equals(selectElementFullColumnName = caseAndExpressionFunction.getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom().getFullColumnName())) {
                            otherFunction = false;
                            break;
                        }
                        otherFunction = true;
                    }
                    if (otherFunction) {
                        subscriptList.add(i + 1);
                    }
                }
            } else {
                boolean otherFunction = false;
                for (int j = 0; j < sqlGroupByItemList.size(); ++j) {
                    String fullColumnName;
                    SqlExpressionAtom sqlExpressionAtom = sqlGroupByItemList.get(j).getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom();
                    if (sqlExpressionAtom.getSqlConstantExpressionAtom() != null) {
                        String literal = sqlExpressionAtom.getSqlConstantExpressionAtom().getLiteral().getLiteral();
                        if (Integer.parseInt(literal) == i + 1) {
                            otherFunction = false;
                            break;
                        }
                        otherFunction = true;
                    }
                    if ((fullColumnName = sqlExpressionAtom.getFullColumnName()) == null) continue;
                    if (sql.contains(fullColumnName)) {
                        otherFunction = false;
                        break;
                    }
                    otherFunction = true;
                }
                if (otherFunction) {
                    subscriptList.add(i + 1);
                }
            }
        }
    }
}

