/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.util;

import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArgs;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.ArrayList;
import java.util.List;

public class JsonFunctionUtil {
    public static String getNewFunction(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        StringBuilder newFunctionSql = new StringBuilder();
        SqlFunctionArgs sqlFunctionArgs = null;
        if (sqlNode.getSqlScalarFunctionCall() != null) {
            sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs();
        }
        if (sqlNode.getSqlUdfFunctionCall() != null) {
            sqlFunctionArgs = sqlNode.getSqlUdfFunctionCall().getSqlFunctionArgs();
        }
        if (sqlFunctionArgs != null) {
            SqlWriter emptyWriter = writer.cloneEmpty();
            for (int i = 0; i < sqlFunctionArgs.getSqlFunctionArgSqlNodeList().getNodes().size(); ++i) {
                sqlFunctionArgs.getSqlFunctionArgSqlNodeList().getNodes().get(i).unparse(emptyWriter, context);
                if (i == sqlFunctionArgs.getSqlFunctionArgSqlNodeList().getNodes().size() - 1) continue;
                emptyWriter.append(",").writeSpace(1);
            }
            String sql = emptyWriter.toSqlString().getSql().replaceAll("\\s", "");
            sql = sql.contains(",'") ? emptyWriter.toSqlString().getSql().replaceAll(",\\s*'", ",'") : emptyWriter.toSqlString().getSql().replaceAll(",\\s*\"", ",'");
            String[] args = sql.split(",'");
            String obj = args[0];
            String path = QuoteUtils.removeAllQuote(args[1].trim());
            String regex = "[a-zA-Z0-9$]+\\s*\\[[0-9]+]";
            String[] parts = path.split("\\.");
            newFunctionSql = new StringBuilder(obj);
            for (int i = 0; i < parts.length; ++i) {
                boolean matches = parts[i].trim().matches(regex);
                if (i == 0) {
                    if (!matches) continue;
                    String index = JsonFunctionUtil.getValuesOfArray(parts[i]).get(1);
                    newFunctionSql = new StringBuilder("json_array_element(" + newFunctionSql + "," + index + ")");
                    continue;
                }
                String arg = parts[i].trim();
                if (matches) {
                    List<String> list = JsonFunctionUtil.getValuesOfArray(arg);
                    if (newFunctionSql.toString().startsWith("jsonb_extract_path")) {
                        int index = newFunctionSql.lastIndexOf(")");
                        String s = newFunctionSql.substring(0, index) + "," + QuoteUtils.addSingleQuote(list.get(0)) + ")";
                        newFunctionSql = new StringBuilder("json_array_element(" + s + "," + list.get(1) + ")");
                        continue;
                    }
                    String s = "jsonb_extract_path(" + newFunctionSql + "," + QuoteUtils.addSingleQuote(list.get(0)) + ")";
                    newFunctionSql = new StringBuilder("json_array_element(" + s + "," + list.get(1) + ")");
                    continue;
                }
                if (newFunctionSql.toString().startsWith("jsonb_extract_path")) {
                    int index = newFunctionSql.lastIndexOf(")");
                    newFunctionSql = new StringBuilder(newFunctionSql.substring(0, index) + "," + QuoteUtils.addSingleQuote(arg) + ")");
                    continue;
                }
                newFunctionSql = new StringBuilder("jsonb_extract_path(" + newFunctionSql + "::jsonb," + QuoteUtils.addSingleQuote(arg) + ")");
            }
        }
        return newFunctionSql.toString();
    }

    private static List<String> getValuesOfArray(String arg) {
        ArrayList<String> result = new ArrayList<String>();
        int left = arg.lastIndexOf("[");
        int right = arg.lastIndexOf("]");
        String index = arg.substring(left + 1, right);
        String name = arg.substring(0, left);
        result.add(name);
        result.add(index);
        return result;
    }
}

