/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.util;

import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeFamily;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.HashMap;

public class TableUtil {
    private static final HashMap<String, SqlPartitionFunctionDefinition.ValuePartitionFormat> map = new HashMap();

    public static void setAutoPartitionType(SqlPartitionFunctionDefinition partitionFunction) {
        if (partitionFunction.getDataTypeSpecName() != null && partitionFunction.getDataTypeSpecName().getFamily() == SqlTypeFamily.NUMERIC) {
            partitionFunction.setValuePartitionFormat(SqlPartitionFunctionDefinition.ValuePartitionFormat.INTEGER);
        } else if (partitionFunction.getDataTypeSpecName() != null && partitionFunction.getDataTypeSpecName().getFamily() == SqlTypeFamily.CHARACTER) {
            partitionFunction.setValuePartitionFormat(SqlPartitionFunctionDefinition.ValuePartitionFormat.DATE);
        } else if (partitionFunction.getStringLiteral() == null) {
            partitionFunction.setValuePartitionFormat(SqlPartitionFunctionDefinition.ValuePartitionFormat.DATE);
        } else {
            String dateFormat = QuoteUtils.removeAllQuote(partitionFunction.getStringLiteral());
            partitionFunction.setValuePartitionFormat(map.getOrDefault(dateFormat, SqlPartitionFunctionDefinition.ValuePartitionFormat.DATE));
        }
    }

    static {
        map.put("%Y%m%d", SqlPartitionFunctionDefinition.ValuePartitionFormat.DATE);
        map.put("%Y%m", SqlPartitionFunctionDefinition.ValuePartitionFormat.YEARMONTH);
        map.put("%Y", SqlPartitionFunctionDefinition.ValuePartitionFormat.YEAR);
    }
}

