/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParserBaseVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractVisitor<T>
extends MySqlParserBaseVisitor<T> {
    private static final Logger LOG = LogManager.getLogger(AbstractVisitor.class);
    private static final String LINE_SEPRATOR_WINDOWS = System.getProperty("line.separator");
    private static final String LINE_SEPRATOR_UNIX = "\n";
    private CommonTokenStream tokens = null;

    public AbstractVisitor() {
    }

    public AbstractVisitor(CommonTokenStream tokens) {
        this();
        this.tokens = tokens;
    }

    protected abstract T defaultResult();

    public CommonTokenStream getTokens() {
        return this.tokens;
    }

    protected List<String> parseCommets(List<Token> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        for (int index = 0; index < tokens.size(); ++index) {
            String chr = tokens.get(index).getText();
            if (index == 0) {
                if (chr.startsWith(LINE_SEPRATOR_WINDOWS)) {
                    chr = chr.substring(LINE_SEPRATOR_WINDOWS.length());
                }
                if (chr.startsWith(LINE_SEPRATOR_UNIX)) {
                    chr = chr.substring(LINE_SEPRATOR_UNIX.length());
                }
                if (chr.isEmpty()) continue;
                comments.add(chr);
                continue;
            }
            comments.add(chr);
        }
        return comments;
    }

    public T visit(ParseTree tree) {
        Object accept = tree.accept((ParseTreeVisitor)this);
        ParseComment parseComment = this.getClass().getAnnotation(ParseComment.class);
        if (parseComment != null) {
            this.visitComment((SqlCommentNode)accept, (ParserRuleContext)tree, parseComment.value());
        }
        return (T)accept;
    }

    protected void visitComment(SqlCommentNode sqlCommentNode, ParserRuleContext context, CommentPosition pos) {
        CommonTokenStream tokenStream = MigrationContextUtil.getTokens();
        if (tokenStream != null) {
            List hiddenTokenList = CommentPosition.PRE == pos ? tokenStream.getHiddenTokensToLeft(context.getStart().getTokenIndex()) : tokenStream.getHiddenTokensToRight(context.getStop().getTokenIndex());
            sqlCommentNode.setCommentPosition(pos);
            sqlCommentNode.setComments(this.parseCommets(hiddenTokenList));
        }
    }
}

