/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.google.common.collect.Lists;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ColumnDefinitionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DefaultValueVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexColumnNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexOptionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableOptionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterByDropConstraintCheckAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterRenameTableAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableAddColumnAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableAddColumnsAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableAddIndexAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableByAddIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableChangeCharsetAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableChangeColumnAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableChangeDefaultCharsetAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableColumnChangeDefaultAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableComment;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableDropColumnAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableDropPrimaryKeyAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableLockAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableModifyColumnAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableOptionAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableTruncatePartitionAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlRenameColumn;
import com.huawei.hwclouds.scs.sql.nodes.SqlRenameIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AlterTableVisitor
extends TableOptionVisitor<SqlAlterTable> {
    private SqlAlterTable alterTable = new SqlAlterTable();

    @Override
    protected SqlAlterTable defaultResult() {
        return this.alterTable;
    }

    @Override
    public SqlAlterTable visitTableName(MySqlParser.TableNameContext ctx) {
        TableNameVisitor visitor = new TableNameVisitor();
        SqlTableName tableName = (SqlTableName)visitor.visit((ParseTree)ctx);
        this.alterTable.setTableName(tableName);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByTableOption(MySqlParser.AlterByTableOptionContext ctx) {
        return (SqlAlterTable)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public SqlAlterTable visitRemovePartition(MySqlParser.RemovePartitionContext ctx) {
        this.alterTable.setRemovePartition(true);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        this.alterByAddColumn(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddColumn(MySqlParser.AlterAddColumnContext ctx) {
        this.alterByAddColumn(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddColumn(MySqlParser.AlterByAddColumnContext ctx, MySqlParser.AlterAddColumnContext ctxNoBy) {
        TerminalNode after;
        TerminalNode first;
        List<MySqlParser.UidContext> uid;
        MySqlParser.ColumnDefinitionContext columnDefinitionContext;
        if (ctx != null) {
            columnDefinitionContext = ctx.columnDefinition();
            uid = ctx.uid();
            first = ctx.FIRST();
            after = ctx.AFTER();
        } else {
            columnDefinitionContext = ctxNoBy.columnDefinition();
            uid = ctxNoBy.uid();
            first = ctxNoBy.FIRST();
            after = ctxNoBy.AFTER();
        }
        SqlAlterTableAddColumnAction addColumnAction = new SqlAlterTableAddColumnAction();
        SqlColumnDefinition columnDefinition = (SqlColumnDefinition)new ColumnDefinitionVisitor().visit((ParseTree)columnDefinitionContext);
        columnDefinition.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(uid.get(0).getText()), false));
        addColumnAction.setColumnDefinition(columnDefinition);
        addColumnAction.setIfExists(false);
        if (first != null) {
            addColumnAction.setFirst(true);
        }
        if (after != null) {
            addColumnAction.setFirst(false);
        }
        if (uid.size() != 1) {
            addColumnAction.setBrotherColumnName(new SqlIdentifier(QuoteUtils.removeQuote(uid.get(1).getText()), false));
        }
        columnDefinition.setAddColumn(true);
        this.alterTable.addAction(addColumnAction);
    }

    @Override
    public SqlAlterTable visitAlterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx) {
        this.alterByAddColumns(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddColumns(MySqlParser.AlterAddColumnsContext ctx) {
        this.alterByAddColumns(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx, MySqlParser.AlterAddColumnsContext ctxNoBy) {
        List<MySqlParser.UidContext> uid;
        List<MySqlParser.ColumnDefinitionContext> columnDefinitionContexts;
        if (ctx != null) {
            columnDefinitionContexts = ctx.columnDefinition();
            uid = ctx.uid();
        } else {
            columnDefinitionContexts = ctxNoBy.columnDefinition();
            uid = ctxNoBy.uid();
        }
        SqlAlterTableAddColumnsAction addColumnsAction = new SqlAlterTableAddColumnsAction();
        SqlNodeList<SqlColumnDefinition> columns = new SqlNodeList<SqlColumnDefinition>();
        for (int i = 0; i < columnDefinitionContexts.size(); ++i) {
            SqlColumnDefinition columnDefinition = (SqlColumnDefinition)new ColumnDefinitionVisitor().visit((ParseTree)columnDefinitionContexts.get(i));
            columnDefinition.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(uid.get(i).getText()), false));
            columnDefinition.setAddColumn(true);
            columns.addNode(columnDefinition);
        }
        addColumnsAction.setColumns(columns);
        this.alterTable.addAction(addColumnsAction);
    }

    @Override
    public SqlAlterTable visitAlterByAddIndex(MySqlParser.AlterByAddIndexContext ctx) {
        this.alterByAddIndex(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddIndex(MySqlParser.AlterAddIndexContext ctx) {
        this.alterByAddIndex(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddIndex(MySqlParser.AlterByAddIndexContext ctx, MySqlParser.AlterAddIndexContext ctxNoBy) {
        MySqlParser.IndexColumnNamesContext indexColumnNamesContext;
        List<MySqlParser.IndexOptionContext> indexOptionContexts;
        MySqlParser.IndexTypeContext indexTypeContext;
        MySqlParser.UidContext uid;
        Token indexFormat;
        if (ctx != null) {
            indexFormat = ctx.indexFormat;
            uid = ctx.uid();
            indexTypeContext = ctx.indexType();
            indexOptionContexts = ctx.indexOption();
            indexColumnNamesContext = ctx.indexColumnNames();
        } else {
            indexFormat = ctxNoBy.indexFormat;
            uid = ctxNoBy.uid();
            indexTypeContext = ctxNoBy.indexType();
            indexOptionContexts = ctxNoBy.indexOption();
            indexColumnNamesContext = ctxNoBy.indexColumnNames();
        }
        SqlCreateIndex index = new SqlCreateIndex();
        SqlAlterTableByAddIndex sqlAlterTableByAddIndex = new SqlAlterTableByAddIndex();
        if (indexFormat != null) {
            index.setIndexFormat(indexFormat.getText());
            sqlAlterTableByAddIndex.setIndexFormat(indexFormat.getText());
        }
        if (uid != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false));
            sqlAlterTableByAddIndex.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false));
        }
        if (indexTypeContext != null) {
            index.setIndexType(indexTypeContext.BTREE() == null ? "HASH" : "BTREE");
            sqlAlterTableByAddIndex.setIndexType(indexTypeContext.getText());
        }
        index.setTableName(this.alterTable.getTableName());
        sqlAlterTableByAddIndex.setTableName(this.alterTable.getTableName());
        index.setSpecialType(SqlCreateIndex.SpecialType.NORMAL);
        index.setOptions(this.indexOption(indexOptionContexts));
        sqlAlterTableByAddIndex.setOptions(this.indexOption(indexOptionContexts));
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < indexColumnNamesContext.indexColumnName().size(); ++i) {
            if (indexColumnNamesContext.indexColumnName(i).expression() != null) {
                sqlAlterTableByAddIndex.setExpression(true);
            }
            indexColumns.addNode((SqlIndexColumnName)((SqlNode)new IndexColumnNameVisitor().visit((ParseTree)indexColumnNamesContext.indexColumnName(i))));
        }
        index.setIndexColumns(indexColumns);
        sqlAlterTableByAddIndex.setIndexColumns(indexColumns);
        this.alterTable.getIndexExtNodeSql().addNode(sqlAlterTableByAddIndex);
        this.alterTable.getIndexExtNodeSql().addNode(index);
    }

    @Override
    public SqlAlterTable visitAlterByAddPrimaryKey(MySqlParser.AlterByAddPrimaryKeyContext ctx) {
        this.alterByAddPrimaryKey(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddPrimaryKey(MySqlParser.AlterAddPrimaryKeyContext ctx) {
        this.alterByAddPrimaryKey(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddPrimaryKey(MySqlParser.AlterByAddPrimaryKeyContext ctx, MySqlParser.AlterAddPrimaryKeyContext ctxNoBy) {
        MySqlParser.IndexColumnNamesContext indexColumnNamesContext;
        List<MySqlParser.IndexOptionContext> indexOptionContexts;
        MySqlParser.IndexTypeContext indexTypeContext;
        List<MySqlParser.UidContext> uid;
        if (ctx != null) {
            uid = ctx.uid();
            indexTypeContext = ctx.indexType();
            indexOptionContexts = ctx.indexOption();
            indexColumnNamesContext = ctx.indexColumnNames();
        } else {
            uid = ctxNoBy.uid();
            indexTypeContext = ctxNoBy.indexType();
            indexOptionContexts = ctxNoBy.indexOption();
            indexColumnNamesContext = ctxNoBy.indexColumnNames();
        }
        SqlCreateIndex index = new SqlCreateIndex();
        if (uid != null && uid.size() > 0) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(uid.get(0).getText()), false));
        }
        if (indexTypeContext != null) {
            index.setIndexType(indexTypeContext.BTREE() == null ? "HASH" : "BTREE");
        }
        index.setTableName(this.alterTable.getTableName());
        index.setSpecialType(SqlCreateIndex.SpecialType.UNIQUE);
        index.setOptions(this.indexOption(indexOptionContexts));
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < indexColumnNamesContext.indexColumnName().size(); ++i) {
            indexColumns.addNode(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(indexColumnNamesContext.indexColumnName(i), true));
        }
        index.setIndexColumns(indexColumns);
        SqlAlterTableAddIndexAction action = new SqlAlterTableAddIndexAction();
        action.setTableName(this.alterTable.getTableName());
        action.setSpecialType(SqlCreateIndex.SpecialType.PRIMARY);
        action.setRefernceIndex(index);
        this.alterTable.addAction(action);
    }

    private SqlIndexOptions indexOption(List<MySqlParser.IndexOptionContext> indexOptionContexts) {
        SqlIndexOptions sqlIndexOptions = new SqlIndexOptions();
        if (indexOptionContexts != null && indexOptionContexts.size() > 0) {
            HashMap<String, String> indexOptions = new HashMap<String, String>();
            for (int i = 0; i < indexOptionContexts.size(); ++i) {
                SqlIndexOptions options = (SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)indexOptionContexts.get(i));
                indexOptions.putAll(options.getIndexOptions());
            }
            sqlIndexOptions.setIndexOptions(indexOptions);
        }
        return sqlIndexOptions;
    }

    @Override
    public SqlAlterTable visitAlterByAddUniqueKey(MySqlParser.AlterByAddUniqueKeyContext ctx) {
        this.alterByAddUniqueKey(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddUniqueKey(MySqlParser.AlterAddUniqueKeyContext ctx) {
        this.alterByAddUniqueKey(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddUniqueKey(MySqlParser.AlterByAddUniqueKeyContext ctx, MySqlParser.AlterAddUniqueKeyContext ctxNoBy) {
        MySqlParser.IndexColumnNamesContext indexColumnNamesContext;
        List<MySqlParser.IndexOptionContext> indexOptionContexts;
        MySqlParser.IndexTypeContext indexTypeContext;
        MySqlParser.UidContext indexName;
        MySqlParser.UidContext name;
        if (ctx != null) {
            name = ctx.name;
            indexName = ctx.indexName;
            indexTypeContext = ctx.indexType();
            indexOptionContexts = ctx.indexOption();
            indexColumnNamesContext = ctx.indexColumnNames();
        } else {
            name = ctxNoBy.name;
            indexName = ctxNoBy.indexName;
            indexTypeContext = ctxNoBy.indexType();
            indexOptionContexts = ctxNoBy.indexOption();
            indexColumnNamesContext = ctxNoBy.indexColumnNames();
        }
        SqlCreateIndex index = new SqlCreateIndex();
        if (name != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(name.getText()), false));
        }
        if (indexName != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(indexName.getText()), false));
        }
        if (indexTypeContext != null) {
            index.setIndexType(indexTypeContext.BTREE() == null ? "HASH" : "BTREE");
        }
        index.setTableName(this.alterTable.getTableName());
        index.setSpecialType(SqlCreateIndex.SpecialType.UNIQUE);
        index.setOptions(this.indexOption(indexOptionContexts));
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < indexColumnNamesContext.indexColumnName().size(); ++i) {
            indexColumns.addNode(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(indexColumnNamesContext.indexColumnName(i), true));
        }
        index.setIndexColumns(indexColumns);
        this.alterTable.getIndependentSqls().addNode(index);
    }

    @Override
    public SqlAlterTable visitAlterByAddSpecialIndex(MySqlParser.AlterByAddSpecialIndexContext ctx) {
        this.alterByAddSpecialIndex(ctx, null);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterAddSpecialIndex(MySqlParser.AlterAddSpecialIndexContext ctx) {
        this.alterByAddSpecialIndex(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddSpecialIndex(MySqlParser.AlterByAddSpecialIndexContext ctx, MySqlParser.AlterAddSpecialIndexContext ctxNoBy) {
        MySqlParser.IndexColumnNamesContext indexColumnNamesContext;
        List<MySqlParser.IndexOptionContext> indexOptionContexts;
        Token keyType;
        MySqlParser.UidContext uid;
        if (ctx != null) {
            uid = ctx.uid();
            keyType = ctx.keyType;
            indexOptionContexts = ctx.indexOption();
            indexColumnNamesContext = ctx.indexColumnNames();
        } else {
            uid = ctxNoBy.uid();
            keyType = ctxNoBy.keyType;
            indexOptionContexts = ctxNoBy.indexOption();
            indexColumnNamesContext = ctxNoBy.indexColumnNames();
        }
        SqlCreateIndex index = new SqlCreateIndex();
        index.setTableName(this.alterTable.getTableName());
        if (uid != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false));
        }
        if (keyType != null) {
            String type = keyType.getText().toUpperCase(Locale.ROOT);
            index.setSpecialType(SqlCreateIndex.SpecialType.valueOf(type));
        } else {
            index.setSpecialType(SqlCreateIndex.SpecialType.NORMAL);
        }
        index.setOptions(this.indexOption(indexOptionContexts));
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < indexColumnNamesContext.indexColumnName().size(); ++i) {
            indexColumns.addNode(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(indexColumnNamesContext.indexColumnName(i), true));
        }
        index.setIndexColumns(indexColumns);
        this.alterTable.getIndependentSqls().addNode(index);
    }

    @Override
    public SqlAlterTable visitAlterByChangeDefault(MySqlParser.AlterByChangeDefaultContext ctx) {
        SqlAlterTableColumnChangeDefaultAction action = new SqlAlterTableColumnChangeDefaultAction();
        action.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
        if (ctx.defaultValue() != null) {
            action.setDefaultValue((SqlLiteral)new DefaultValueVisitor().visit((ParseTree)ctx.defaultValue()));
        }
        if (ctx.DROP() != null) {
            action.setDropDefault(true);
        } else {
            action.setDropDefault(false);
        }
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        SqlAlterTableChangeColumnAction action = new SqlAlterTableChangeColumnAction();
        action.setOldColumn(new SqlIdentifier(QuoteUtils.removeQuote(ctx.oldColumn.getText()), false));
        action.setTableName(this.defaultResult().getTableName());
        SqlColumnDefinition columnDefinition = (SqlColumnDefinition)new ColumnDefinitionVisitor().visit((ParseTree)ctx.columnDefinition());
        columnDefinition.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.newColumn.getText()), false));
        action.setNewColumn(columnDefinition);
        if (ctx.FIRST() != null) {
            action.setFirst(true);
        }
        if (ctx.AFTER() != null) {
            action.setFirst(false);
        }
        if (ctx.afterColumn != null) {
            action.setBrotherColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.afterColumn.getText()), false));
        }
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByLock(MySqlParser.AlterByLockContext ctx) {
        SqlAlterTableLockAction action = new SqlAlterTableLockAction();
        action.setLockType(SqlAlterTableLockAction.LockType.valueOf(ctx.lockType.getText()));
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        SqlAlterTableModifyColumnAction action = new SqlAlterTableModifyColumnAction();
        action.setTableName(this.defaultResult().getTableName());
        SqlColumnDefinition columnDefinition = (SqlColumnDefinition)new ColumnDefinitionVisitor().visit((ParseTree)ctx);
        columnDefinition.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid(0).getText()), false));
        action.setColumnDefinition(columnDefinition);
        if (ctx.FIRST() != null) {
            action.setFirst(true);
        }
        if (ctx.AFTER() != null) {
            action.setFirst(false);
        }
        if (ctx.uid().size() != 1) {
            action.setBrotherColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid(1).getText()), false));
        }
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByDropColumn(MySqlParser.AlterByDropColumnContext ctx) {
        SqlAlterTableDropColumnAction action = new SqlAlterTableDropColumnAction();
        action.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().get(0).getText()), false));
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByDropConstraintCheck(MySqlParser.AlterByDropConstraintCheckContext ctx) {
        SqlAlterByDropConstraintCheckAction action = new SqlAlterByDropConstraintCheckAction();
        action.setDropType(ctx.CHECK() != null ? ctx.CHECK().getText() : ctx.CONSTRAINT().getText());
        action.setIfExist(ctx.ifExists() != null);
        action.setUid(ctx.uid().getText());
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByDropPrimaryKey(MySqlParser.AlterByDropPrimaryKeyContext ctx) {
        SqlAlterTableDropPrimaryKeyAction dropPrimaryKeyAction = new SqlAlterTableDropPrimaryKeyAction();
        dropPrimaryKeyAction.setTableName(this.defaultResult().getTableName());
        this.alterTable.addAction(dropPrimaryKeyAction);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByDropIndex(MySqlParser.AlterByDropIndexContext ctx) {
        SqlDropIndex drop = new SqlDropIndex();
        SqlTableName tableName = this.alterTable.getTableName();
        SqlIdentifier indexName = new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false);
        drop.getTableIndexs().put(tableName, Lists.newArrayList((Object[])new SqlIdentifier[]{indexName}));
        drop.setCascade(false);
        drop.setExists(false);
        this.alterTable.getIndependentSqls().addNode(drop);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByRename(MySqlParser.AlterByRenameContext ctx) {
        SqlTableName sqlTableName = new SqlTableName();
        MySqlParser.FullIdContext fullIdContext = ctx.fullId();
        if (fullIdContext.uid() != null) {
            sqlTableName.setTableName(new SqlIdentifier(QuoteUtils.removeQuote(fullIdContext.uid().getText()), false));
        }
        if (fullIdContext.scheOrDbName != null) {
            sqlTableName.setDatabaseName(new SqlIdentifier(QuoteUtils.removeQuote(fullIdContext.uid().getText()), false));
            String tbName = fullIdContext.scheOrDbName.getText().replace(".", "");
            sqlTableName.setTableName(new SqlIdentifier(QuoteUtils.removeQuote(tbName), false));
        }
        if (fullIdContext.tabName != null) {
            sqlTableName.setDatabaseName(new SqlIdentifier(QuoteUtils.removeQuote(fullIdContext.uid().getText()), false));
            String schName = fullIdContext.scheOrDbName.getText().replace(".", "");
            sqlTableName.setSchemaName(new SqlIdentifier(QuoteUtils.removeQuote(schName), false));
            String tbName = fullIdContext.tabName.getText().replace(".", "");
            sqlTableName.setTableName(new SqlIdentifier(QuoteUtils.removeQuote(tbName), false));
        }
        SqlAlterRenameTableAction action = new SqlAlterRenameTableAction();
        action.setNewTableName(sqlTableName);
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByRenameColumn(MySqlParser.AlterByRenameColumnContext ctx) {
        List<SqlRenameColumn> sqlRenameColumnList = this.alterTable.getSqlRenameColumnList();
        SqlRenameColumn sqlRenameColumn = new SqlRenameColumn();
        sqlRenameColumn.setTableName(this.alterTable.getTableName());
        String oldColumn = QuoteUtils.removeQuote(ctx.oldColumn.getText());
        String newColumn = QuoteUtils.removeQuote(ctx.newColumn.getText());
        sqlRenameColumn.setOldColumn(QuoteUtils.addDoubleQuote(oldColumn));
        sqlRenameColumn.setNewColumn(QuoteUtils.addDoubleQuote(newColumn));
        sqlRenameColumnList.add(sqlRenameColumn);
        this.alterTable.setSqlRenameColumnList(sqlRenameColumnList);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByRenameIndex(MySqlParser.AlterByRenameIndexContext ctx) {
        String tableName = QuoteUtils.removeAllQuote(this.alterTable.getTableName().getTableName().getIdentifier());
        List<SqlRenameIndex> sqlRenameIndexList = this.alterTable.getSqlRenameIndexList();
        SqlRenameIndex sqlRenameIndex = new SqlRenameIndex();
        String oldIndexName = QuoteUtils.removeQuote(ctx.uid(0).getText());
        String newIndexName = QuoteUtils.removeQuote(ctx.uid(1).getText());
        sqlRenameIndex.setOldIndexName(QuoteUtils.addDoubleQuote(oldIndexName));
        sqlRenameIndex.setNewIndexName(QuoteUtils.addDoubleQuote(newIndexName));
        sqlRenameIndex.setTableName(tableName);
        sqlRenameIndexList.add(sqlRenameIndex);
        this.alterTable.setSqlRenameIndexList(sqlRenameIndexList);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByAlterIndexVisibility(MySqlParser.AlterByAlterIndexVisibilityContext ctx) {
        this.alterTable.setAlterType("INDEX_VISIBILITY");
        if (ctx.VISIBLE() != null) {
            this.alterTable.setAlterTypeContent(ctx.VISIBLE().getText());
        } else {
            this.alterTable.setAlterTypeContent(ctx.INVISIBLE().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByPartitions(MySqlParser.AlterByPartitionsContext ctx) {
        if (ctx.decimalLiteral() != null) {
            this.alterTable.setAlterType("PARTITIONS");
            this.alterTable.setAlterTypeContent(ctx.decimalLiteral().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitTableOptionRtEngine(MySqlParser.TableOptionRtEngineContext ctx) {
        if (ctx.STRING_LITERAL() != null) {
            this.alterTable.setAlterType("RT_ENGINE");
            this.alterTable.setAlterTypeContent(ctx.STRING_LITERAL().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitPartitionDefinitions(MySqlParser.PartitionDefinitionsContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!(ctx.getChild(i) instanceof MySqlParser.PartitionFunctionDefinitionContext) || ctx.partitionFunctionDefinition() == null || !(ctx.partitionFunctionDefinition() instanceof MySqlParser.PartitionFunctionValueContext)) continue;
            this.alterTable.setAlterType("PARTITION_DEFINITIONS");
            this.alterTable.setAlterTypeContent(((MySqlParser.PartitionFunctionValueContext)ctx.partitionFunctionDefinition()).fullColumnName().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitTableOptionStoragePolicy(MySqlParser.TableOptionStoragePolicyContext ctx) {
        if (ctx.STRING_LITERAL() != null) {
            this.alterTable.setAlterType("STORAGE_POLICY");
            this.alterTable.setAlterTypeContent(ctx.STRING_LITERAL().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByConvertCharset(MySqlParser.AlterByConvertCharsetContext ctx) {
        SqlAlterTableChangeCharsetAction action = new SqlAlterTableChangeCharsetAction();
        action.setCharsetName(new SqlLiteral(SqlTypeName.ANY, ctx.charsetName().getText()));
        if (ctx.COLLATE() != null) {
            action.setCollationName(new SqlLiteral(SqlTypeName.ANY, ctx.collationName().getText()));
        }
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByDefaultCharset(MySqlParser.AlterByDefaultCharsetContext ctx) {
        SqlAlterTableChangeDefaultCharsetAction action = new SqlAlterTableChangeDefaultCharsetAction();
        action.setCharsetName(new SqlLiteral(SqlTypeName.ANY, ctx.charsetName().getText()));
        if (ctx.COLLATE() != null) {
            action.setCollationName(new SqlLiteral(SqlTypeName.ANY, ctx.collationName().getText()));
        }
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByTruncatePartition(MySqlParser.AlterByTruncatePartitionContext ctx) {
        SqlAlterTableTruncatePartitionAction truncatePartitionAction = new SqlAlterTableTruncatePartitionAction();
        ArrayList<SqlIdentifier> partitionNames = new ArrayList<SqlIdentifier>();
        if (ctx.ALL() != null) {
            truncatePartitionAction.setAll(true);
        } else if (ctx.uidList() != null) {
            for (int i = 0; i < ctx.uidList().uid().size(); ++i) {
                SqlIdentifier partitionName = new SqlIdentifier(QuoteUtils.addDoubleQuoteAndToLowerCase(ctx.uidList().uid().get(i).getText()), false);
                partitionNames.add(partitionName);
            }
            truncatePartitionAction.setPartitionName(partitionNames);
        }
        this.alterTable.addAction(truncatePartitionAction);
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterBySetAlgorithm(MySqlParser.AlterBySetAlgorithmContext ctx) {
        return this.defaultResult();
    }

    @Override
    public SqlAlterTable visitAlterByAddClause(MySqlParser.AlterByAddClauseContext ctx) {
        for (int i = 0; i < ctx.alterByAdd().size(); ++i) {
            MySqlParser.AlterByAddContext alterByAddContext = ctx.alterByAdd().get(i);
            if (alterByAddContext instanceof MySqlParser.AlterAddColumnContext) {
                this.visitAlterAddColumn((MySqlParser.AlterAddColumnContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddColumnsContext) {
                this.visitAlterAddColumns((MySqlParser.AlterAddColumnsContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddIndexContext) {
                this.visitAlterAddIndex((MySqlParser.AlterAddIndexContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddPrimaryKeyContext) {
                this.visitAlterAddPrimaryKey((MySqlParser.AlterAddPrimaryKeyContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddUniqueKeyContext) {
                this.visitAlterAddUniqueKey((MySqlParser.AlterAddUniqueKeyContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddSpecialIndexContext) {
                this.visitAlterAddSpecialIndex((MySqlParser.AlterAddSpecialIndexContext)alterByAddContext);
                continue;
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddForeignKeyContext) {
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "add foreign key");
            }
            if (alterByAddContext instanceof MySqlParser.AlterAddCheckTableConstraintContext) {
                this.visitAlterAddCheckTableConstraint((MySqlParser.AlterAddCheckTableConstraintContext)alterByAddContext);
                continue;
            }
            if (!(alterByAddContext instanceof MySqlParser.AlterAddPartitionContext)) continue;
            this.visitAlterAddPartition((MySqlParser.AlterAddPartitionContext)alterByAddContext);
        }
        return this.defaultResult();
    }

    @Override
    protected void addOption(SqlTableOption option) {
        SqlAlterTableOptionAction action = new SqlAlterTableOptionAction();
        option.setTableName(this.alterTable.getTableName());
        action.alterOption(option);
        this.alterTable.addAction(action);
    }

    @Override
    public SqlAlterTable visitAlterBySetDefault(MySqlParser.AlterBySetDefaultContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table set default");
    }

    @Override
    public SqlAlterTable visitAlterByRenameRollup(MySqlParser.AlterByRenameRollupContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table rename rollup");
    }

    @Override
    public SqlAlterTable visitAlterByRenamePartition(MySqlParser.AlterByRenamePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table rename partition");
    }

    @Override
    public SqlAlterTable visitAlterByReplace(MySqlParser.AlterByReplaceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table replace");
    }

    @Override
    public SqlAlterTable visitAlterProperty(MySqlParser.AlterPropertyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table property");
    }

    @Override
    public SqlAlterTable visitAlterTableComment(MySqlParser.AlterTableCommentContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table table comment");
    }

    @Override
    public SqlAlterTable visitAlterTableColComment(MySqlParser.AlterTableColCommentContext ctx) {
        SqlAlterTableComment action = new SqlAlterTableComment();
        action.setColumnName(new SqlIdentifier(ctx.uid().getText()));
        action.setComment(ctx.STRING_LITERAL().getText());
        this.alterTable.addAction(action);
        return this.defaultResult();
    }

    public String getNewIndexName(MySqlParser.IndexColumnNamesContext ctx) {
        String str = this.alterTable.getTableName().getTableName().getIdentifier();
        StringBuilder indexNameBuffer = new StringBuilder();
        indexNameBuffer.append("IDX_" + str);
        for (int i = 0; i < ctx.indexColumnName().size(); ++i) {
            String name = ctx.indexColumnName(i).getText();
            if (name.indexOf("(") != -1) {
                name = name.substring(0, name.indexOf("("));
            }
            indexNameBuffer.append("_" + name);
        }
        String indexName = indexNameBuffer.toString();
        if (indexName.length() > 63) {
            indexName = indexName.substring(0, 63);
        }
        return indexName;
    }
}

