/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ColumnDefinitionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.PartitionDefinitionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.PartitionFunctionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.PartitionOptionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SubPartitionFunctionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableConstraintDeclarationVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableIndexDeclarationVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableOptionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinitions;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionOptionParameter;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubPartitionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionClusteredBy;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionRowFormat;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionStoragePolicy;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;

public class ColumnCreateTableVisitor
extends TableOptionVisitor<SqlCreateTable> {
    private SqlCreateTable createTable = new SqlCreateTable();

    @Override
    protected SqlCreateTable defaultResult() {
        return this.createTable;
    }

    @Override
    public SqlCreateTable visitTableDescription(MySqlParser.TableDescriptionContext ctx) {
        this.createTable.setExternal(ctx.EXTERNAL() != null);
        this.createTable.setDimension(ctx.DIMENSION() != null);
        this.createTable.setTemporary(ctx.TEMPORARY() != null);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitTableName(MySqlParser.TableNameContext ctx) {
        TableNameVisitor visitor = new TableNameVisitor();
        SqlTableName tableName = (SqlTableName)visitor.visit((ParseTree)ctx);
        this.createTable.setTableName(tableName);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitIfNotExists(MySqlParser.IfNotExistsContext ctx) {
        this.createTable.setIfExists(true);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitCreateDefinitions(MySqlParser.CreateDefinitionsContext ctx) {
        for (int i = 1; i < ctx.getChildCount() - 1; ++i) {
            SqlTableConstraint constraints;
            if (ctx.getChild(i) instanceof MySqlParser.ColumnDeclarationContext) {
                MySqlParser.ColumnDeclarationContext declarationContext = (MySqlParser.ColumnDeclarationContext)ctx.getChild(i);
                SqlColumnDefinition createDef = (SqlColumnDefinition)new ColumnDefinitionVisitor().visit((ParseTree)declarationContext);
                createDef.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(declarationContext.uid().getText()), false));
                this.createTable.getColumns().add(createDef);
            }
            if (ctx.getChild(i) instanceof MySqlParser.ConstraintDeclarationContext && (constraints = (SqlTableConstraint)new TableConstraintDeclarationVisitor().visit(ctx.getChild(i))) != null) {
                List<SqlColumnDefinition> sdList = this.createNewList(this.createTable.getColumns(), constraints);
                this.createTable.setColumns(sdList);
                this.createTable.getConstraints().add(constraints);
            }
            if (ctx.getChild(i) instanceof MySqlParser.IndexDeclarationContext) {
                SqlCreateIndex indexs = (SqlCreateIndex)new TableIndexDeclarationVisitor(this.createTable.getTableName()).visit(ctx.getChild(i));
                this.createTable.getIndexs().add(indexs);
            }
            ++i;
        }
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitTableOptionClusteredBy(MySqlParser.TableOptionClusteredByContext ctx) {
        this.getClusterOption(ctx.uidList());
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitTableOptionStoragePolicy(MySqlParser.TableOptionStoragePolicyContext ctx) {
        SqlTableOptionStoragePolicy sqlTableOptionStoragePolicy = new SqlTableOptionStoragePolicy();
        if (ctx.decimalLiteral() != null) {
            sqlTableOptionStoragePolicy.setCount(ctx.decimalLiteral().getText());
        }
        sqlTableOptionStoragePolicy.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.createTable.setSqlTableOptionStoragePolicy(sqlTableOptionStoragePolicy);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitTableOptionRtEngine(MySqlParser.TableOptionRtEngineContext ctx) {
        if (ctx.STRING_LITERAL() != null) {
            this.createTable.setRtEngine(ctx.STRING_LITERAL().getText());
        }
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitTableOptionRowFormat(MySqlParser.TableOptionRowFormatContext ctx) {
        SqlTableOptionRowFormat sqlTableOptionRowFormat = new SqlTableOptionRowFormat();
        if (ctx.ROW_FORMAT() != null) {
            sqlTableOptionRowFormat.setRowFormat(SqlTableOptionRowFormat.FormatType.valueOf(ctx.rowFormat.getText().toUpperCase(Locale.US)));
        }
        this.createTable.setSqlTableOptionRowFormat(sqlTableOptionRowFormat);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitRemovePartition(MySqlParser.RemovePartitionContext ctx) {
        this.createTable.setRemovePartition(true);
        return this.defaultResult();
    }

    @Override
    public SqlCreateTable visitPartitionDefinitions(MySqlParser.PartitionDefinitionsContext ctx) {
        SqlPartitionDefinitions partitionDefinitions = new SqlPartitionDefinitions();
        partitionDefinitions.setOriginPartitionSql(CommonUtils.getText(ctx, 2));
        if (ctx.PARTITIONS() != null) {
            partitionDefinitions.setPartitions("PARTITIONS");
            partitionDefinitions.setCount(ctx.count.getText());
        } else if (ctx.PARTITION_NUM() != null) {
            partitionDefinitions.setPartitions("PARTITION NUM");
            partitionDefinitions.setCount(ctx.count.getText());
        }
        if (ctx.SUBPARTITIONS() != null) {
            partitionDefinitions.setSubCount(ctx.subCount.getText());
        } else if (ctx.AVAILABLE_PARTITION_NUM() != null) {
            partitionDefinitions.setSubCountAdb(ctx.subCountAdb.getText());
        }
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) instanceof MySqlParser.PartitionFunctionDefinitionContext && ctx.partitionFunctionDefinition() != null) {
                SqlPartitionFunctionDefinition functionDefinition = (SqlPartitionFunctionDefinition)new PartitionFunctionVisitor().visit(ctx.getChild(i));
                partitionDefinitions.setPartitionFunctionDefinition(functionDefinition);
            }
            if (ctx.getChild(i) instanceof MySqlParser.SubpartitionFunctionDefinitionContext && ctx.SUBPARTITION() != null) {
                SqlSubPartitionFunctionDefinition subFunctionDefinition = (SqlSubPartitionFunctionDefinition)new SubPartitionFunctionVisitor().visit(ctx.getChild(i));
                partitionDefinitions.setSubPartitionFunctionDefinition(subFunctionDefinition);
            }
            if (!(ctx.getChild(i) instanceof MySqlParser.PartitionDefinitionContext) || ctx.partitionDefinition() == null || ctx.partitionDefinition().isEmpty()) continue;
            SqlPartitionDefinition partitionDefinition = (SqlPartitionDefinition)new PartitionDefinitionVisitor().visit(ctx.getChild(i));
            this.getPartitionOptionAndSub(ctx, i, partitionDefinition);
            partitionDefinitions.getPartitionDefinition().addNode(partitionDefinition);
        }
        this.createTable.setPartitionDefinitions(partitionDefinitions);
        return this.createTable;
    }

    @Override
    public SqlCreateTable visitPartitionOptions(MySqlParser.PartitionOptionsContext ctx) {
        if (this.createTable.getPartitionDefinitions() != null && this.createTable.getPartitionDefinitions().getPartitionFunctionDefinition() != null) {
            SqlPartitionOptions sqlPartitionOptions = new SqlPartitionOptions();
            this.visitPartitionOptions(sqlPartitionOptions, ctx);
            this.createTable.getPartitionDefinitions().getPartitionFunctionDefinition().setSqlPartitionOptions(sqlPartitionOptions);
        }
        return this.createTable;
    }

    private void visitPartitionOptions(SqlPartitionOptions sqlPartitionOptions, MySqlParser.PartitionOptionsContext partitionOptionsContext) {
        SqlNodeList<SqlPartitionOptionParameter> partitionOptionParameterSqlNodeList = new SqlNodeList<SqlPartitionOptionParameter>();
        for (int i = 0; i < partitionOptionsContext.partitionOptionParameter().size(); ++i) {
            SqlPartitionOptionParameter sqlPartitionOptionParameter = new SqlPartitionOptionParameter();
            MySqlParser.PartitionOptionParameterContext partitionOptionParameterContext = partitionOptionsContext.partitionOptionParameter().get(i);
            if (partitionOptionParameterContext.PARTITION_EXPIRATION_DAYS() != null) {
                sqlPartitionOptionParameter.setParameterKey("PARTITION_EXPIRATION_DAYS");
                sqlPartitionOptionParameter.setParameterValue(partitionOptionParameterContext.decimalLiteral().getText());
            } else if (partitionOptionParameterContext.REQUIRE_PARTITION_FILTER() != null) {
                sqlPartitionOptionParameter.setParameterKey("REQUIRE_PARTITION_FILTER");
                sqlPartitionOptionParameter.setParameterValue(partitionOptionParameterContext.TRUE() != null ? "TRUE" : "FALSE");
            } else {
                if (partitionOptionParameterContext.DESCRIPTION() == null) continue;
                sqlPartitionOptionParameter.setParameterKey("DESCRIPTION");
                sqlPartitionOptionParameter.setParameterValue(partitionOptionParameterContext.STRING_LITERAL().getText());
            }
            partitionOptionParameterSqlNodeList.addNode(sqlPartitionOptionParameter);
        }
        sqlPartitionOptions.setPartitionOptionParameterSqlNodeList(partitionOptionParameterSqlNodeList);
    }

    @Override
    public SqlCreateTable visitBigQueryTableOptionClusterBy(MySqlParser.BigQueryTableOptionClusterByContext ctx) {
        this.getClusterOption(ctx.uidList());
        return this.createTable;
    }

    private void getClusterOption(MySqlParser.UidListContext uidList) {
        SqlTableOptionClusteredBy sqlTableOptionClusteredBy = new SqlTableOptionClusteredBy();
        SqlNodeList<SqlIdentifier> list = new SqlNodeList<SqlIdentifier>();
        for (int i = 0; i < uidList.uid().size(); ++i) {
            list.addNode(new SqlIdentifier(QuoteUtils.removeAllQuote(uidList.uid(i).getText())));
        }
        sqlTableOptionClusteredBy.setUidList(list);
        this.createTable.setSqlTableOptionClusteredBy(sqlTableOptionClusteredBy);
    }

    private void getPartitionOptionAndSub(MySqlParser.PartitionDefinitionsContext ctx, int i, SqlPartitionDefinition partitionDefinition) {
        SqlNodeList<SqlPartitionOption> partitionOptions = new SqlNodeList<SqlPartitionOption>();
        SqlNodeList subPartitionOptions = new SqlNodeList();
        SqlNodeList<SqlSubPartitionDefinition> subPartitionDefiniton = new SqlNodeList<SqlSubPartitionDefinition>();
        for (int j = 1; j < ctx.getChild(i).getChildCount(); ++j) {
            if (ctx.getChild(i).getChild(j) instanceof MySqlParser.PartitionOptionContext) {
                SqlPartitionOption partitionOption = (SqlPartitionOption)new PartitionOptionVisitor().visit(ctx.getChild(i).getChild(j));
                partitionOptions.addNode(partitionOption);
            }
            if (!(ctx.getChild(i).getChild(j) instanceof MySqlParser.SubpartitionDefinitionContext)) continue;
            SqlSubPartitionDefinition subPartition = new SqlSubPartitionDefinition();
            MySqlParser.SubpartitionDefinitionContext subPartitionDefinition = (MySqlParser.SubpartitionDefinitionContext)ctx.getChild(i).getChild(j);
            this.getSubPartitionDefine(subPartitionOptions, subPartition, subPartitionDefinition);
            subPartitionDefiniton.addNode(subPartition);
        }
        partitionDefinition.setPartitionOption(partitionOptions);
        partitionDefinition.setSubpartitionDefinition(subPartitionDefiniton);
    }

    private void getSubPartitionDefine(SqlNodeList subPartitionOptions, SqlSubPartitionDefinition subPartition, MySqlParser.SubpartitionDefinitionContext subPartitionDefinition) {
        subPartition.setUid(new SqlLiteral(SqlTypeName.TEXT, subPartitionDefinition.uid().getText()));
        if (subPartitionDefinition.partitionOption() != null && !subPartitionDefinition.partitionOption().isEmpty()) {
            for (int m = 1; m < subPartitionDefinition.getChildCount(); ++m) {
                if (!(subPartitionDefinition.getChild(m) instanceof MySqlParser.PartitionOptionContext)) continue;
                SqlPartitionOption partitionOption = (SqlPartitionOption)new PartitionOptionVisitor().visit(subPartitionDefinition.getChild(m));
                subPartitionOptions.addNode(partitionOption);
            }
            subPartition.setPartitionOption(subPartitionOptions);
        }
    }

    @Override
    protected void addOption(SqlTableOption option) {
        option.setTableName(this.defaultResult().getTableName());
        this.createTable.addOption(option);
    }

    private List<SqlColumnDefinition> createNewList(List<SqlColumnDefinition> oldList, SqlTableConstraint constraint) {
        ArrayList<SqlColumnDefinition> newColList = new ArrayList();
        if (constraint instanceof SqlPKeyTableConstraint) {
            for (SqlColumnDefinition sd : oldList) {
                SqlPKeyTableConstraint pc = (SqlPKeyTableConstraint)constraint;
                for (int i = 0; i < pc.getIndexColumns().getNodes().size(); ++i) {
                    SqlIndexColumnName sc = pc.getIndexColumns().getNodes().get(i);
                    if (!sd.getColumnName().getIdentifier().equals(sc.getColumnName().getIdentifier())) continue;
                    sd.setPrimaryKey(true);
                    sd.setConstraintPK(true);
                }
                newColList.add(sd);
            }
        } else if (constraint instanceof SqlUKeyTableConstraint) {
            for (SqlColumnDefinition sd : oldList) {
                SqlUKeyTableConstraint pc = (SqlUKeyTableConstraint)constraint;
                for (int i = 0; i < pc.getIndexColumns().size(); ++i) {
                    SqlIndexColumnName sc = pc.getIndexColumns().get(i);
                    if (!sd.getColumnName().getIdentifier().equals(sc.getColumnName().getIdentifier())) continue;
                    sd.setConstraintUK(true);
                }
                newColList.add(sd);
            }
        } else {
            newColList = oldList;
        }
        return newColList;
    }

    @Override
    public SqlCreateTable visitTableOptionTableProperties(MySqlParser.TableOptionTablePropertiesContext ctx) {
        this.createTable.getTableOptionTextList().add(ctx.getText());
        return this.createTable;
    }

    @Override
    public SqlCreateTable visitTableOptionUnsupportParse(MySqlParser.TableOptionUnsupportParseContext ctx) {
        this.createTable.getTableOptionTextList().add(ctx.getText());
        return this.createTable;
    }
}

