/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.google.common.collect.Lists;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AlterDatabaseVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AlterTableVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AlterViewVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.BlockStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ColumnCreateTableVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.CopyCreateTableVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.CreateIndexVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DataTypeVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DmlStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.QueryCreateTableVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SqlStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SynapseCreateTableVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterRenameTableAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterResourceGroup;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableSpace;
import com.huawei.hwclouds.scs.sql.nodes.SqlBlockStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateDatabase;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateDatabaseOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateFunction;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateResourceGroup;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateServer;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTableSpace;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTrigger;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateView;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropDatabase;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropFunction;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropProcedure;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropResourceGroup;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropServer;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropTableSpace;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropView;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlProcedureParameter;
import com.huawei.hwclouds.scs.sql.nodes.SqlRoot;
import com.huawei.hwclouds.scs.sql.nodes.SqlRoutineBody;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlServerOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTruncateTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DdlStatementVisitor
extends AbstractVisitor<SqlCommentNode> {
    private static final Logger LOGGER = LogManager.getLogger(DdlStatementVisitor.class);

    @Override
    protected SqlCommentNode defaultResult() {
        return null;
    }

    @Override
    public SqlCommentNode visitCreateAssignment(MySqlParser.CreateAssignmentContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create assignment");
    }

    @Override
    public SqlCommentNode visitCreateCapacity(MySqlParser.CreateCapacityContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create capacity");
    }

    @Override
    public SqlCommentNode visitCreateDatabase(MySqlParser.CreateDatabaseContext ctx) {
        LOGGER.info("visitCreateDatabase enter ");
        SqlCreateDatabase createDatabase = new SqlCreateDatabase();
        createDatabase.setIfExists(ctx.ifNotExists() != null);
        createDatabase.setExternal(ctx.EXTERNAL() != null);
        createDatabase.setName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
        ArrayList<SqlCreateDatabaseOption> createDBOptions = new ArrayList<SqlCreateDatabaseOption>();
        List<MySqlParser.CreateDatabaseOptionContext> createDatabaseOptionContexts = ctx.createDatabaseOption();
        for (MySqlParser.CreateDatabaseOptionContext createDatabaseOptionContext : createDatabaseOptionContexts) {
            SqlCreateDatabaseOption sqlCreateDatabaseOption = new SqlCreateDatabaseOption();
            if (createDatabaseOptionContext.charsetName() != null) {
                LOGGER.info("Create database charset name : {}", (Object)createDatabaseOptionContext.charsetName().getText());
                sqlCreateDatabaseOption.setCharsetName(new SqlLiteral(SqlTypeName.CHAR, createDatabaseOptionContext.charsetName().getText()));
            }
            if (createDatabaseOptionContext.collationName() != null) {
                LOGGER.info("Create database collate name : {}", (Object)createDatabaseOptionContext.collationName().getText());
                sqlCreateDatabaseOption.setCollactionName(new SqlLiteral(SqlTypeName.CHAR, createDatabaseOptionContext.collationName().getText()));
            }
            createDBOptions.add(sqlCreateDatabaseOption);
        }
        createDatabase.setSqlCreateDatabaseOptions(createDBOptions);
        return createDatabase;
    }

    @Override
    public SqlCommentNode visitCreateEvent(MySqlParser.CreateEventContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create event");
    }

    @Override
    public SqlCommentNode visitCreateIndex(MySqlParser.CreateIndexContext ctx) {
        return new CreateIndexVisitor().visitCreateIndex(ctx);
    }

    @Override
    public SqlCommentNode visitCreateResourceGroup(MySqlParser.CreateResourceGroupContext ctx) {
        SqlCreateResourceGroup sqlCreateResourceGroup = new SqlCreateResourceGroup();
        sqlCreateResourceGroup.setResourceGroupName(ctx.stringLiteral().getText());
        if (ctx.queryType != null) {
            sqlCreateResourceGroup.setQueryType(ctx.queryType.getText());
        }
        if (ctx.decimalLiteral() != null) {
            sqlCreateResourceGroup.setNodeNum(ctx.decimalLiteral().getText());
        }
        return sqlCreateResourceGroup;
    }

    @Override
    public SqlCommentNode visitCreateLogfileGroup(MySqlParser.CreateLogfileGroupContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create logfile group");
    }

    @Override
    public SqlCommentNode visitCreateProcedure(MySqlParser.CreateProcedureContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create procedure");
    }

    @Override
    public SqlCommentNode visitCreateFunction(MySqlParser.CreateFunctionContext ctx) {
        SqlCreateFunction sqlCreateFunction = new SqlCreateFunction();
        SqlRoutineBody sqlRoutineBody = new SqlRoutineBody();
        ArrayList<SqlProcedureParameter> parameterList = new ArrayList<SqlProcedureParameter>();
        if (ctx.fullId() != null) {
            sqlCreateFunction.setFullId(ctx.fullId().getText());
        }
        if (!ctx.functionParameter().isEmpty()) {
            for (int i = 0; i < ctx.functionParameter().size(); ++i) {
                SqlProcedureParameter sqlProcedureParameter = new SqlProcedureParameter();
                sqlProcedureParameter.setUid(ctx.functionParameter().get(i).uid().getText());
                if (ctx.functionParameter().get(i).dataType() != null) {
                    sqlProcedureParameter.setDataType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.functionParameter().get(i).dataType()));
                }
                parameterList.add(sqlProcedureParameter);
            }
            sqlCreateFunction.setProcedureParameters(parameterList);
        }
        if (ctx.dataType() != null) {
            sqlCreateFunction.setDataType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.dataType()));
        }
        if (ctx.routineBody() != null) {
            if (ctx.routineBody().blockStatement() != null) {
                sqlRoutineBody.setBlockStatement((SqlBlockStatement)new BlockStatementVisitor().visit((ParseTree)ctx.routineBody().blockStatement()));
            } else {
                sqlRoutineBody.setSqlStatement((SqlCommentNode)new SqlStatementVisitor().visit((ParseTree)ctx.routineBody().sqlStatement()));
            }
            sqlCreateFunction.setSqlRoutineBody(sqlRoutineBody);
        }
        if (ctx.returnStatement() != null) {
            sqlCreateFunction.setSqlExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.returnStatement().expression()));
        }
        return sqlCreateFunction;
    }

    @Override
    public SqlCommentNode visitCreateReservation(MySqlParser.CreateReservationContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create reservation");
    }

    @Override
    public SqlCommentNode visitCreateServer(MySqlParser.CreateServerContext ctx) {
        SqlCreateServer sqlCreateServer = new SqlCreateServer();
        SqlNodeList<SqlServerOption> serverOptionSqlNodeList = new SqlNodeList<SqlServerOption>();
        if (ctx.uid() != null) {
            sqlCreateServer.setUid(ctx.uid().getText());
        }
        if (ctx.wrapperName != null) {
            sqlCreateServer.setWrapperName(ctx.wrapperName.getText());
        }
        if (ctx.serverOption() != null) {
            for (int i = 0; i < ctx.serverOption().size(); ++i) {
                SqlServerOption sqlServerOption = new SqlServerOption();
                MySqlParser.ServerOptionContext optionContext = ctx.serverOption().get(i);
                if (optionContext.HOST() != null) {
                    sqlServerOption.setHost(optionContext.HOST().getText());
                } else if (optionContext.USER() != null) {
                    sqlServerOption.setUser(optionContext.USER().getText());
                } else if (optionContext.PASSWORD() != null) {
                    sqlServerOption.setPassword(optionContext.PASSWORD().getText());
                } else if (optionContext.DATABASE() != null) {
                    sqlServerOption.setDatabase(optionContext.DATABASE().getText());
                }
                if (optionContext.STRING_LITERAL() != null) {
                    sqlServerOption.setStringLiteral(optionContext.STRING_LITERAL().getText());
                }
                if (optionContext.PORT() != null) {
                    sqlServerOption.setPort(optionContext.PORT().getText());
                    sqlCreateServer.setHavingPort(true);
                    sqlServerOption.setDecimalLiteral(optionContext.decimalLiteral().getText());
                }
                serverOptionSqlNodeList.addNode(sqlServerOption);
            }
            sqlCreateServer.setSqlServerOptions(serverOptionSqlNodeList);
        }
        return sqlCreateServer;
    }

    @Override
    public SqlCommentNode visitCopyCreateTable(MySqlParser.CopyCreateTableContext ctx) {
        return (SqlCommentNode)new CopyCreateTableVisitor().visit((ParseTree)ctx.parent);
    }

    @Override
    public SqlCommentNode visitQueryCreateTable(MySqlParser.QueryCreateTableContext ctx) {
        return (SqlCommentNode)new QueryCreateTableVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        return (SqlCommentNode)new ColumnCreateTableVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitSynapseCreateTable(MySqlParser.SynapseCreateTableContext ctx) {
        return (SqlCommentNode)new SynapseCreateTableVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitCloneCreateTable(MySqlParser.CloneCreateTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create snapshot or create table clone");
    }

    @Override
    public SqlCommentNode visitCreateTablespaceInnodb(MySqlParser.CreateTablespaceInnodbContext ctx) {
        SqlCreateTableSpace sqlCreateTableSpace = new SqlCreateTableSpace();
        if (ctx.uid() != null) {
            sqlCreateTableSpace.setUid(ctx.uid().getText());
        }
        if (ctx.DATAFILE() != null) {
            sqlCreateTableSpace.setDatafile(ctx.STRING_LITERAL().getText());
        }
        return sqlCreateTableSpace;
    }

    @Override
    public SqlCommentNode visitCreateTablespaceNdb(MySqlParser.CreateTablespaceNdbContext ctx) {
        SqlCreateTableSpace sqlCreateTableSpace = new SqlCreateTableSpace();
        if (ctx.uid() != null) {
            sqlCreateTableSpace.setUid(ctx.uid().get(0).getText());
        }
        if (ctx.DATAFILE() != null) {
            sqlCreateTableSpace.setDatafile(ctx.STRING_LITERAL().get(0).getText());
        }
        return sqlCreateTableSpace;
    }

    @Override
    public SqlCommentNode visitCreateTrigger(MySqlParser.CreateTriggerContext ctx) {
        SqlCreateTrigger sqlCreateTrigger = new SqlCreateTrigger();
        SqlRoutineBody sqlRoutineBody = new SqlRoutineBody();
        if (ctx.thisTrigger != null) {
            sqlCreateTrigger.setFullId(ctx.thisTrigger.getText());
        }
        if (ctx.triggerTime != null) {
            sqlCreateTrigger.setTriggerTime(ctx.triggerTime.getText());
        }
        if (ctx.triggerEvent != null) {
            sqlCreateTrigger.setTriggerEvent(ctx.triggerEvent.getText());
        }
        if (ctx.tableName() != null) {
            sqlCreateTrigger.setTableName(ctx.tableName().getText());
        }
        if (ctx.routineBody() != null) {
            if (ctx.routineBody().getText().toUpperCase(Locale.ROOT).contains("NEW.")) {
                sqlCreateTrigger.setNew(true);
            }
            if (ctx.routineBody().blockStatement() != null) {
                sqlRoutineBody.setBlockStatement((SqlBlockStatement)new BlockStatementVisitor().visit((ParseTree)ctx.routineBody().blockStatement()));
            } else {
                sqlRoutineBody.setSqlStatement((SqlCommentNode)new SqlStatementVisitor().visit((ParseTree)ctx.routineBody().sqlStatement()));
            }
            sqlCreateTrigger.setSqlRoutineBody(sqlRoutineBody);
        }
        return sqlCreateTrigger;
    }

    @Override
    public SqlCommentNode visitCreateView(MySqlParser.CreateViewContext ctx) {
        SqlCreateView sqlCreateView = new SqlCreateView();
        if (ctx.OR() != null) {
            sqlCreateView.setHavingOr(true);
        }
        if (ctx.fullId() != null) {
            sqlCreateView.setFullId(ctx.fullId().getText());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (ctx.viewUidList() != null) {
            MySqlParser.ViewUidListContext viewUidListContext = ctx.viewUidList();
            for (int i = 0; i < viewUidListContext.viewUid().size(); ++i) {
                list.add(viewUidListContext.viewUid().get(i).uid().getText());
            }
            sqlCreateView.setUidList(list);
        }
        if (ctx.selectStatement() != null) {
            DmlStatementVisitor visitor = new DmlStatementVisitor();
            SqlSelectStatement sqlSelectStatement = (SqlSelectStatement)visitor.visit((ParseTree)ctx.selectStatement());
            sqlCreateView.setSelectStatement(sqlSelectStatement);
        }
        return sqlCreateView;
    }

    @Override
    public SqlCommentNode visitAlterSimpleDatabase(MySqlParser.AlterSimpleDatabaseContext ctx) {
        return (SqlCommentNode)new AlterDatabaseVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitAlterUpgradeName(MySqlParser.AlterUpgradeNameContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter database statement");
    }

    @Override
    public SqlCommentNode visitAlterSchemaForBigQuery(MySqlParser.AlterSchemaForBigQueryContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter schema options");
    }

    @Override
    public SqlCommentNode visitAlterEvent(MySqlParser.AlterEventContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter event");
    }

    @Override
    public SqlCommentNode visitAlterFunction(MySqlParser.AlterFunctionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter function");
    }

    @Override
    public SqlCommentNode visitAlterInstance(MySqlParser.AlterInstanceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter instance rotate");
    }

    @Override
    public SqlCommentNode visitAlterResourceGroup(MySqlParser.AlterResourceGroupContext ctx) {
        SqlAlterResourceGroup sqlAlterResourceGroup = new SqlAlterResourceGroup();
        sqlAlterResourceGroup.setResourceGroupName(ctx.stringLiteral().getText());
        if (ctx.queryType != null) {
            sqlAlterResourceGroup.setQueryType(ctx.queryType.getText());
        }
        if (ctx.decimalLiteral() != null) {
            sqlAlterResourceGroup.setNodeNum(ctx.decimalLiteral().getText());
        }
        if (ctx.addUserName != null) {
            sqlAlterResourceGroup.setAddUserName(ctx.addUserName.getText());
        }
        if (ctx.dropUserName != null) {
            sqlAlterResourceGroup.setDropUserName(ctx.dropUserName.getText());
        }
        return sqlAlterResourceGroup;
    }

    @Override
    public SqlCommentNode visitAlterLogfileGroup(MySqlParser.AlterLogfileGroupContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter logfile group");
    }

    @Override
    public SqlCommentNode visitAlterProcedure(MySqlParser.AlterProcedureContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter procedure");
    }

    @Override
    public SqlCommentNode visitAlterServer(MySqlParser.AlterServerContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter server");
    }

    @Override
    public SqlCommentNode visitAlterTable(MySqlParser.AlterTableContext ctx) {
        return (SqlCommentNode)new AlterTableVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitAlterTablespace(MySqlParser.AlterTablespaceContext ctx) {
        SqlAlterTableSpace sqlAlterTableSpace = new SqlAlterTableSpace();
        if (ctx.uid() != null) {
            sqlAlterTableSpace.setUid(ctx.uid().getText());
        }
        if (ctx.fullId() != null) {
            sqlAlterTableSpace.setFullId(ctx.fullId().getText());
        }
        return sqlAlterTableSpace;
    }

    @Override
    public SqlCommentNode visitAlterView(MySqlParser.AlterViewContext ctx) {
        return (SqlCommentNode)new AlterViewVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitDropDatabase(MySqlParser.DropDatabaseContext ctx) {
        SqlDropDatabase dropDatabase = new SqlDropDatabase();
        dropDatabase.setIfExists(ctx.ifExists() != null);
        dropDatabase.setName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
        return dropDatabase;
    }

    @Override
    public SqlCommentNode visitDropEvent(MySqlParser.DropEventContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop event");
    }

    @Override
    public SqlCommentNode visitDropIndex(MySqlParser.DropIndexContext ctx) {
        SqlDropIndex drop = new SqlDropIndex();
        SqlTableName tableName = (SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName());
        SqlIdentifier indexName = new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false);
        drop.getTableIndexs().put(tableName, Lists.newArrayList((Object[])new SqlIdentifier[]{indexName}));
        drop.setCascade(false);
        drop.setExists(false);
        if (ctx.LOCK() != null) {
            if (ctx.LOCK().getText().equals("DEFAULT") || ctx.LOCK().getText().equals("EXCLUSIVE")) {
                drop.setCurrently(false);
            } else {
                drop.setCurrently(true);
            }
        }
        return drop;
    }

    @Override
    public SqlCommentNode visitDropResourceGroup(MySqlParser.DropResourceGroupContext ctx) {
        SqlDropResourceGroup sqlDropResourceGroup = new SqlDropResourceGroup();
        sqlDropResourceGroup.setResourceGroupName(ctx.stringLiteral().getText());
        return sqlDropResourceGroup;
    }

    @Override
    public SqlCommentNode visitDropLogfileGroup(MySqlParser.DropLogfileGroupContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop logfile group");
    }

    @Override
    public SqlCommentNode visitDropProcedure(MySqlParser.DropProcedureContext ctx) {
        SqlDropProcedure sqlDropProcedure = new SqlDropProcedure();
        if (ctx.ifExists() != null) {
            sqlDropProcedure.setIfExists(true);
        }
        if (ctx.fullId() != null) {
            sqlDropProcedure.setProcedureName(ctx.fullId().getText());
        }
        return sqlDropProcedure;
    }

    @Override
    public SqlCommentNode visitDropFunction(MySqlParser.DropFunctionContext ctx) {
        SqlDropFunction sqlDropFunction = new SqlDropFunction();
        if (ctx.ifExists() != null) {
            sqlDropFunction.setIfExists(true);
        }
        if (ctx.fullId() != null) {
            sqlDropFunction.setFunctionName(ctx.fullId().getText());
        }
        return sqlDropFunction;
    }

    @Override
    public SqlCommentNode visitDropServer(MySqlParser.DropServerContext ctx) {
        SqlDropServer sqlDropServer = new SqlDropServer();
        if (ctx.ifExists() != null) {
            sqlDropServer.setIfExists(true);
        }
        if (ctx.uid() != null) {
            sqlDropServer.setServerName(ctx.uid().getText());
        }
        return sqlDropServer;
    }

    @Override
    public SqlCommentNode visitDropTable(MySqlParser.DropTableContext ctx) {
        SqlDropTable dropTable = new SqlDropTable();
        dropTable.setExists(ctx.ifExists() != null);
        dropTable.setTemporary(ctx.TEMPORARY() != null);
        if (ctx.SNAPSHOT() != null || ctx.EXTERNAL() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop snapshot orexternal table ");
        }
        List<SqlTableName> tables = ctx.tables().tableName().stream().map(tree -> (SqlTableName)new TableNameVisitor().visit((ParseTree)tree)).collect(Collectors.toList());
        dropTable.setTables(tables);
        return dropTable;
    }

    @Override
    public SqlCommentNode visitDropTablespace(MySqlParser.DropTablespaceContext ctx) {
        SqlDropTableSpace sqlDropTableSpace = new SqlDropTableSpace();
        if (ctx.uid() != null) {
            sqlDropTableSpace.setUid(ctx.uid().getText());
        }
        return sqlDropTableSpace;
    }

    @Override
    public SqlCommentNode visitDropTrigger(MySqlParser.DropTriggerContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop trigger");
    }

    @Override
    public SqlCommentNode visitDropView(MySqlParser.DropViewContext ctx) {
        SqlDropView sqlDropView = new SqlDropView();
        if (ctx.ifExists() != null) {
            sqlDropView.setIfExists(true);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (ctx.fullId() != null) {
            for (int i = 0; i < ctx.fullId().size(); ++i) {
                list.add(ctx.fullId().get(i).getText());
            }
            sqlDropView.setViewNames(list);
        }
        if (ctx.CASCADE() != null) {
            sqlDropView.setDropType(ctx.CASCADE().getText());
        } else if (ctx.RESTRICT() != null) {
            sqlDropView.setDropType(ctx.RESTRICT().getText());
        }
        return sqlDropView;
    }

    @Override
    public SqlCommentNode visitDropCapacity(MySqlParser.DropCapacityContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop capacity");
    }

    @Override
    public SqlCommentNode visitDropReservation(MySqlParser.DropReservationContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop reservation");
    }

    @Override
    public SqlCommentNode visitDropAssignment(MySqlParser.DropAssignmentContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop assignment");
    }

    @Override
    public SqlCommentNode visitRenameTable(MySqlParser.RenameTableContext ctx) {
        SqlRoot list = new SqlRoot();
        for (MySqlParser.RenameTableClauseContext renameContext : ctx.renameTableClause()) {
            SqlAlterRenameTableAction renameAction = new SqlAlterRenameTableAction();
            renameAction.setNewTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)renameContext.tableName(1)));
            SqlAlterTable alert = new SqlAlterTable();
            alert.setExists(false);
            alert.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)renameContext.tableName(0)));
            alert.addAction(renameAction);
            list.addNode(alert);
        }
        return list;
    }

    @Override
    public SqlCommentNode visitTruncateTable(MySqlParser.TruncateTableContext ctx) {
        SqlTruncateTable sqlNode = new SqlTruncateTable();
        sqlNode.getTables().add((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName()));
        if (ctx.partitionName() != null && ctx.partitionName().size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < ctx.partitionName().size(); ++i) {
                list.add(ctx.partitionName().get(i).getText());
            }
            sqlNode.setPartitionNames(list);
        }
        sqlNode.setCascade(false);
        sqlNode.setRestartIdentity(false);
        return sqlNode;
    }

    @Override
    public SqlCommentNode visitCreateCatalog(MySqlParser.CreateCatalogContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Catalog");
    }

    @Override
    public SqlCommentNode visitAlterCatalog(MySqlParser.AlterCatalogContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Alter Catalog");
    }

    @Override
    public SqlCommentNode visitDropCatalog(MySqlParser.DropCatalogContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Drop Catalog");
    }

    @Override
    public SqlCommentNode visitCreateFile(MySqlParser.CreateFileContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create File");
    }

    @Override
    public SqlCommentNode visitCreatePolicy(MySqlParser.CreatePolicyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Policy");
    }

    @Override
    public SqlCommentNode visitCreateEncryptkey(MySqlParser.CreateEncryptkeyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Encryptkey");
    }

    @Override
    public SqlCommentNode visitCreateResource(MySqlParser.CreateResourceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Resource");
    }

    @Override
    public SqlCommentNode visitCreateWorkloadGroup(MySqlParser.CreateWorkloadGroupContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Workload Group");
    }

    @Override
    public SqlCommentNode visitCreateSqlBlockRule(MySqlParser.CreateSqlBlockRuleContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create SQL_BLOCK_RULE");
    }

    @Override
    public SqlCommentNode visitCreateMaterializedView(MySqlParser.CreateMaterializedViewContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create Materialized View");
    }

    @Override
    public SqlCommentNode visitDropMaterializedView(MySqlParser.DropMaterializedViewContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Drop Materialized View");
    }
}

