/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.CollectionStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ConditionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.InsertReplaceStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.OrderByExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ParenthesisSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.QueryExpressionNoIntoVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.QueryExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.QuerySpecificationVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SimpleSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableSourceVisitor;
import com.huawei.hwclouds.scs.sql.nodes.Condition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCollectionSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlCollectionStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlDeleteStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlDoStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFullColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlLimit;
import com.huawei.hwclouds.scs.sql.nodes.SqlLimitClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlMultipleDeleteStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlMultipleUpdateStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlOrderByClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlOrderByExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlParenthesisSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlQueryExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlQueryExpressionNoInto;
import com.huawei.hwclouds.scs.sql.nodes.SqlQuerySpecification;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSimpleSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSource;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSources;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdate;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdatedElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdatedElementInMul;
import com.huawei.hwclouds.scs.sql.nodes.TableNameWithStar;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class DmlStatementVisitor
extends AbstractVisitor<SqlCommentNode> {
    @Override
    protected SqlCommentNode defaultResult() {
        return null;
    }

    @Override
    public SqlCommentNode visitSimpleSelect(MySqlParser.SimpleSelectContext ctx) {
        SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
        sqlSelectStatement.setSqlSimpleSelect((SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)ctx));
        return sqlSelectStatement;
    }

    @Override
    public SqlCommentNode visitParenthesisSelect(MySqlParser.ParenthesisSelectContext ctx) {
        SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
        sqlSelectStatement.setSqlParenthesisSelect((SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)ctx));
        return sqlSelectStatement;
    }

    @Override
    public SqlCommentNode visitCollectionSelect(MySqlParser.CollectionSelectContext ctx) {
        SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
        SqlCollectionSelect sqlCollectionSelect = new SqlCollectionSelect();
        sqlCollectionSelect.setIfHaveLBracket(ctx.LR_BRACKET() != null);
        sqlCollectionSelect.setIfHaveRBracket(ctx.RR_BRACKET() != null);
        if (ctx.first != null) {
            sqlCollectionSelect.setFSqlQuerySpecification((SqlQuerySpecification)new QuerySpecificationVisitor().visit((ParseTree)ctx.first));
        } else {
            sqlCollectionSelect.setSqlQueryExpressionNoInto((SqlQueryExpressionNoInto)new QueryExpressionNoIntoVisitor().visit((ParseTree)ctx.queryExpressionNointo()));
        }
        SqlNodeList<SqlCollectionStatement> sqlCollectionStatementSqlNodeList = new SqlNodeList<SqlCollectionStatement>();
        for (int i = 0; i < ctx.collectionStatement().size(); ++i) {
            SqlCollectionStatement sqlCollectionStatement = (SqlCollectionStatement)new CollectionStatementVisitor().visit((ParseTree)ctx.collectionStatement(i));
            sqlCollectionStatementSqlNodeList.addNode(sqlCollectionStatement);
        }
        sqlCollectionSelect.setSqlCollectionStatementSqlNodeList(sqlCollectionStatementSqlNodeList);
        if (ctx.operator != null) {
            if (ctx.UNION() != null) {
                sqlCollectionSelect.setOperator(ctx.UNION().getText());
            } else if (ctx.INTERSECT() != null) {
                sqlCollectionSelect.setOperator(ctx.INTERSECT().getText());
            } else if (ctx.EXCEPT() != null) {
                sqlCollectionSelect.setOperator(ctx.EXCEPT().getText());
            }
            if (ctx.operatorType != null) {
                if (ctx.ALL() != null) {
                    sqlCollectionSelect.setOperatorType(ctx.ALL().getText());
                } else {
                    sqlCollectionSelect.setOperatorType(ctx.DISTINCT().getText());
                }
            }
            if (ctx.second != null) {
                sqlCollectionSelect.setSSqlQuerySpecification((SqlQuerySpecification)new QuerySpecificationVisitor().visit((ParseTree)ctx.second));
            } else {
                sqlCollectionSelect.setSqlQueryExpression((SqlQueryExpression)new QueryExpressionVisitor().visit((ParseTree)ctx.queryExpression()));
            }
        }
        if (ctx.orderByClause() != null) {
            SqlOrderByClause sqlOrderByClause = new SqlOrderByClause();
            SqlNodeList<SqlOrderByExpression> list = new SqlNodeList<SqlOrderByExpression>();
            for (int i = 0; i < ctx.orderByClause().orderByExpression().size(); ++i) {
                SqlOrderByExpression sqlOrderByExpression = (SqlOrderByExpression)new OrderByExpressionVisitor().visit((ParseTree)ctx.orderByClause().orderByExpression(i));
                list.addNode(sqlOrderByExpression);
            }
            sqlOrderByClause.setSqlOrderByExpressionSqlNodeList(list);
            sqlOrderByClause.setRollup(ctx.orderByClause().ROLLUP() != null);
            sqlCollectionSelect.setSqlOrderByClause(sqlOrderByClause);
        }
        if (ctx.limitClause() != null) {
            SqlLimitClause sqlLimitClause = new SqlLimitClause();
            sqlLimitClause.setLimitAtom(ctx.limitClause().limit.getText());
            if (ctx.limitClause().offset != null) {
                sqlLimitClause.setOffsetAtom(ctx.limitClause().offset.getText());
            }
            if (ctx.limitClause().OFFSET() != null) {
                sqlLimitClause.setOffSet(true);
            }
            sqlCollectionSelect.setSqlLimitClause(sqlLimitClause);
        }
        if (ctx.lockClause() != null) {
            SqlLockClause sqlLockClause = new SqlLockClause();
            sqlLockClause.setLockClause(ctx.lockClause().getText());
            sqlCollectionSelect.setSqlLockClause(sqlLockClause);
        }
        sqlSelectStatement.setSqlCollectionSelect(sqlCollectionSelect);
        return sqlSelectStatement;
    }

    @Override
    public SqlCommentNode visitInsertStatement(MySqlParser.InsertStatementContext ctx) {
        return (SqlCommentNode)new InsertReplaceStatementVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitSingleUpdateStatement(MySqlParser.SingleUpdateStatementContext ctx) {
        SqlUpdate update = new SqlUpdate();
        update.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName()));
        if (ctx.uid() != null) {
            update.setTableNameAlias(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
            this.visitComment(update.getTableName(), ctx.uid(), CommentPosition.INLIST);
        } else {
            this.visitComment(update.getTableName(), ctx.tableName(), CommentPosition.INLIST);
        }
        if (ctx.IGNORE() != null) {
            update.setPriority(ctx.IGNORE().getText());
        } else if (ctx.LOW_PRIORITY() != null) {
            update.setPriority(ctx.LOW_PRIORITY().getText());
        }
        SqlNodeList<SqlUpdatedElement> updates = new SqlNodeList<SqlUpdatedElement>();
        this.getUpdateCloums(updates, ctx);
        update.setUpdateColumns(updates);
        if (ctx.WHERE() != null) {
            update.setWhereClause((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        }
        if (ctx.orderByClause() != null) {
            update.setOrderByClause(ctx.orderByClause().orderByExpression().stream().map(context -> context.getText()).collect(Collectors.joining(",")));
        }
        if (ctx.limitClause() != null) {
            SqlLimit limit = new SqlLimit();
            limit.setLimit(new SqlLiteral(SqlTypeName.DECIMAL, ctx.limitClause().limit.getText()));
            if (ctx.limitClause().offset != null) {
                limit.setOffset(new SqlLiteral(SqlTypeName.DECIMAL, ctx.limitClause().offset.getText()));
            }
            update.setLimit(limit);
        }
        return update;
    }

    @Override
    public SqlCommentNode visitTableStatement(MySqlParser.TableStatementContext ctx) {
        SqlTableElement sqlTableElement = new SqlTableElement();
        sqlTableElement.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName()));
        if (ctx.orderByClause() != null) {
            SqlOrderByClause sqlOrderByClause = new SqlOrderByClause();
            SqlNodeList<SqlOrderByExpression> list = new SqlNodeList<SqlOrderByExpression>();
            for (int i = 0; i < ctx.orderByClause().orderByExpression().size(); ++i) {
                SqlOrderByExpression sqlOrderByExpression = (SqlOrderByExpression)new OrderByExpressionVisitor().visit((ParseTree)ctx.orderByClause().orderByExpression(i));
                list.addNode(sqlOrderByExpression);
            }
            sqlOrderByClause.setSqlOrderByExpressionSqlNodeList(list);
            sqlOrderByClause.setRollup(ctx.orderByClause().ROLLUP() != null);
            sqlTableElement.setSqlOrderByClause(sqlOrderByClause);
        }
        if (ctx.limitClause() != null) {
            SqlLimitClause sqlLimitClause = new SqlLimitClause();
            sqlLimitClause.setLimitAtom(ctx.limitClause().limit.getText());
            if (ctx.limitClause().offset != null) {
                sqlLimitClause.setOffsetAtom(ctx.limitClause().offset.getText());
            }
            if (ctx.limitClause().OFFSET() != null) {
                sqlLimitClause.setOffSet(true);
            }
            sqlTableElement.setSqlLimitClause(sqlLimitClause);
        }
        sqlTableElement.setWithSemicolon(true);
        return sqlTableElement;
    }

    private void getUpdateCloums(SqlNodeList<SqlUpdatedElement> updates, MySqlParser.SingleUpdateStatementContext ctx) {
        for (MySqlParser.UpdatedElementContext element : ctx.updatedElement()) {
            SqlNodeList<SqlIdentifier> names = new SqlNodeList<SqlIdentifier>();
            if (element.fullColumnName().uid() != null) {
                names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(element.fullColumnName().uid().getText()), false));
            }
            if (element.fullColumnName().dottedId() != null) {
                for (MySqlParser.DottedIdContext dottedId : element.fullColumnName().dottedId()) {
                    names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(dottedId.getText().substring(1)), false));
                }
            }
            SqlFullColumnName columnName = new SqlFullColumnName();
            columnName.setNames(names);
            SqlUpdatedElement updateElement = new SqlUpdatedElement();
            updateElement.setColumnName(columnName);
            if (element.DEFAULT() != null) {
                updateElement.setUseDefault(true);
            } else {
                ExpressionVisitor expressionVisitor = new ExpressionVisitor();
                SqlExpression sqlExpression = (SqlExpression)expressionVisitor.visit((ParseTree)element.expression());
                updateElement.setSqlExpression(sqlExpression);
            }
            this.visitComment(updateElement, element, CommentPosition.INLIST);
            updates.addNode(updateElement);
        }
    }

    @Override
    public SqlCommentNode visitMultipleUpdateStatement(MySqlParser.MultipleUpdateStatementContext ctx) {
        SqlMultipleUpdateStatement sqlMultipleUpdateStatement = new SqlMultipleUpdateStatement();
        sqlMultipleUpdateStatement.setIfHavePriority(ctx.priority != null);
        sqlMultipleUpdateStatement.setIfHaveIgnore(ctx.IGNORE() != null);
        SqlTableSources sqlTableSources = new SqlTableSources();
        SqlNodeList<SqlTableSource> sqlTableSource = new SqlNodeList<SqlTableSource>();
        for (int i = 0; i < ctx.tableSources().tableSource().size(); ++i) {
            sqlTableSource.addNode((SqlTableSource)new TableSourceVisitor().visit((ParseTree)ctx.tableSources().tableSource().get(i)));
        }
        sqlTableSources.setSqlTableSource(sqlTableSource);
        sqlMultipleUpdateStatement.setSqlTableSources(sqlTableSources);
        SqlNodeList<SqlUpdatedElementInMul> sqlUpdatedElementInMulSqlNodeList = new SqlNodeList<SqlUpdatedElementInMul>();
        for (int i = 0; i < ctx.updatedElement().size(); ++i) {
            SqlUpdatedElementInMul sqlUpdatedElementInMul = new SqlUpdatedElementInMul();
            sqlUpdatedElementInMul.setFullColumnName(ctx.updatedElement().get(i).fullColumnName().getText());
            if (ctx.updatedElement().get(i).expression() != null) {
                sqlUpdatedElementInMul.setExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.updatedElement().get(i).expression()));
            } else {
                sqlUpdatedElementInMul.setIfHaveDefault(true);
            }
            this.visitComment(sqlUpdatedElementInMul, ctx.updatedElement().get(i), CommentPosition.INLIST);
            sqlUpdatedElementInMulSqlNodeList.addNode(sqlUpdatedElementInMul);
        }
        sqlMultipleUpdateStatement.setUpdatedElements(sqlUpdatedElementInMulSqlNodeList);
        if (ctx.condition() != null) {
            sqlMultipleUpdateStatement.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        }
        return sqlMultipleUpdateStatement;
    }

    @Override
    public SqlCommentNode visitSingleDeleteStatement(MySqlParser.SingleDeleteStatementContext ctx) {
        SqlDeleteStatement delete = new SqlDeleteStatement();
        delete.setIgnore(ctx.IGNORE() != null);
        delete.setQuick(ctx.QUICK() != null);
        delete.setLowPriority(ctx.priority != null);
        delete.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName()));
        this.visitComment(delete.getTableName(), ctx.tableName(), CommentPosition.POST);
        SqlNodeList<SqlIdentifier> partitions = new SqlNodeList<SqlIdentifier>();
        if (ctx.uidList() != null) {
            ctx.uidList().uid().stream().forEach(uid -> partitions.addNode(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false)));
        }
        delete.setPartitions(partitions);
        if (ctx.WHERE() != null) {
            delete.setWhereClause((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        }
        if (ctx.orderByClause() != null) {
            delete.setOrderByClause(ctx.orderByClause().orderByExpression().stream().map(context -> context.getText()).collect(Collectors.joining(",")));
        }
        if (ctx.limitClauseAtom() != null && ctx.limitClauseAtom().decimalLiteral() != null) {
            SqlLimit limit = new SqlLimit();
            limit.setLimit(new SqlLiteral(SqlTypeName.DECIMAL, ctx.limitClauseAtom().decimalLiteral().getText()));
            delete.setLimit(limit);
        }
        return delete;
    }

    @Override
    public SqlCommentNode visitMultipleDeleteStatement(MySqlParser.MultipleDeleteStatementContext ctx) {
        SqlMultipleDeleteStatement sqlMultipleDeleteStatement = new SqlMultipleDeleteStatement();
        sqlMultipleDeleteStatement.setIfHavePriority(ctx.LOW_PRIORITY() != null);
        sqlMultipleDeleteStatement.setIfHaveQuick(ctx.QUICK() != null);
        sqlMultipleDeleteStatement.setIfHaveIgnore(ctx.IGNORE() != null);
        SqlNodeList<TableNameWithStar> tableNameWithStarList = new SqlNodeList<TableNameWithStar>();
        for (int i = 0; i < ctx.tableNameWithStar().size(); ++i) {
            TableNameWithStar tableNameWithStar = new TableNameWithStar();
            tableNameWithStar.setTableName(ctx.tableNameWithStar().get(i).tableName().getText());
            tableNameWithStar.setIfHaveStar(ctx.tableNameWithStar().get(i).STAR() != null);
            this.visitComment(tableNameWithStar, ctx.tableNameWithStar().get(i), CommentPosition.INLIST);
            tableNameWithStarList.addNode(tableNameWithStar);
        }
        sqlMultipleDeleteStatement.setTableNameWithStarList(tableNameWithStarList);
        sqlMultipleDeleteStatement.setIfHaveUsing(ctx.USING() != null);
        SqlTableSources sqlTableSources = new SqlTableSources();
        SqlNodeList<SqlTableSource> sqlTableSource = new SqlNodeList<SqlTableSource>();
        for (int i = 0; i < ctx.tableSources().tableSource().size(); ++i) {
            sqlTableSource.addNode((SqlTableSource)new TableSourceVisitor().visit((ParseTree)ctx.tableSources().tableSource().get(i)));
        }
        sqlTableSources.setSqlTableSource(sqlTableSource);
        sqlMultipleDeleteStatement.setTableSources(sqlTableSources);
        if (ctx.condition() != null) {
            sqlMultipleDeleteStatement.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        }
        return sqlMultipleDeleteStatement;
    }

    @Override
    public SqlCommentNode visitReplaceStatement(MySqlParser.ReplaceStatementContext ctx) {
        return (SqlCommentNode)new InsertReplaceStatementVisitor().visit((ParseTree)ctx);
    }

    @Override
    public SqlCommentNode visitCallStatement(MySqlParser.CallStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "call statement");
    }

    @Override
    public SqlCommentNode visitLoadDataStatement(MySqlParser.LoadDataStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "load data");
    }

    @Override
    public SqlCommentNode visitLoadXmlStatement(MySqlParser.LoadXmlStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "load xml");
    }

    @Override
    public SqlCommentNode visitDoStatement(MySqlParser.DoStatementContext ctx) {
        SqlDoStatement doStatement = new SqlDoStatement();
        SqlNodeList<SqlLiteral> expressions = new SqlNodeList<SqlLiteral>();
        ctx.expressions().expression().stream().forEach(expression -> expressions.addNode(new SqlLiteral(SqlTypeName.TEXT, expression.getText())));
        doStatement.setExpressions(expressions);
        return doStatement;
    }

    @Override
    public SqlCommentNode visitHandlerOpenStatement(MySqlParser.HandlerOpenStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "handler table_name open");
    }

    @Override
    public SqlCommentNode visitHandlerReadIndexStatement(MySqlParser.HandlerReadIndexStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "handler table_name read");
    }

    @Override
    public SqlCommentNode visitHandlerReadStatement(MySqlParser.HandlerReadStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "handler table_name read");
    }

    @Override
    public SqlCommentNode visitHandlerCloseStatement(MySqlParser.HandlerCloseStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "handler table_name close");
    }
}

