/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.PredicateVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlLogicalExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlNotExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlPredicateExpression;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionVisitor
extends AbstractVisitor<SqlExpression> {
    protected SqlExpression sqlExpression = new SqlExpression();

    @Override
    public SqlExpression defaultResult() {
        return this.sqlExpression;
    }

    @Override
    public SqlExpression visitNotExpression(MySqlParser.NotExpressionContext ctx) {
        SqlNotExpression sqlNotExpression = new SqlNotExpression();
        if (ctx.notOperator != null) {
            if (ctx.NOT() != null) {
                sqlNotExpression.setNegation(ctx.NOT().getText());
            } else {
                sqlNotExpression.setNegation(ctx.EXCLAMATION_SYMBOL().getText());
            }
        }
        sqlNotExpression.setSqlExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        this.sqlExpression.setSqlNotExpression(sqlNotExpression);
        return this.defaultResult();
    }

    @Override
    public SqlExpression visitLogicalExpression(MySqlParser.LogicalExpressionContext ctx) {
        SqlLogicalExpression sqlLogicalExpression = new SqlLogicalExpression();
        sqlLogicalExpression.setLogicalOperator(ctx.logicalOperator().getText());
        SqlExpression frontExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression(0));
        SqlExpression behindExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression(1));
        sqlLogicalExpression.setFrontExpression(frontExpression);
        sqlLogicalExpression.setBehindExpression(behindExpression);
        this.sqlExpression.setSqlLogicalExpression(sqlLogicalExpression);
        return this.defaultResult();
    }

    @Override
    public SqlExpression visitIsExpression(MySqlParser.IsExpressionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "IS NOT? BOOLEAN");
    }

    @Override
    public SqlExpression visitPredicateExpression(MySqlParser.PredicateExpressionContext ctx) {
        SqlPredicate sqlPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate());
        SqlPredicateExpression sqlPredicateExpression = new SqlPredicateExpression();
        sqlPredicateExpression.setSqlPredicate(sqlPredicate);
        this.sqlExpression.setSqlPredicateExpression(sqlPredicateExpression);
        return this.defaultResult();
    }
}

