/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.sql.nodes.RangeBucket;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.Locale;

public class PartitionFunctionVisitor
extends AbstractVisitor<SqlPartitionFunctionDefinition> {
    private static final String DATE_FROM_PREFIX = "`DATE_FORMAT(";
    private SqlPartitionFunctionDefinition partitionFunction = new SqlPartitionFunctionDefinition();

    @Override
    protected SqlPartitionFunctionDefinition defaultResult() {
        return this.partitionFunction;
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionHash(MySqlParser.PartitionFunctionHashContext ctx) {
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.HASH);
        this.partitionFunction.setLinear(ctx.LINEAR() != null);
        this.partitionFunction.setExpression(ctx.expression().getText());
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionKey(MySqlParser.PartitionFunctionKeyContext ctx) {
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.KEY);
        this.partitionFunction.setLinear(ctx.LINEAR() != null);
        if (ctx.ALGORITHM() != null) {
            this.partitionFunction.setAlgorithm(ctx.algType.getText());
        }
        SqlNodeList<SqlIdentifier> partitionCols = new SqlNodeList<SqlIdentifier>();
        ctx.uidList().uid().stream().forEach(uid -> partitionCols.addNode(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false)));
        this.partitionFunction.setColumnName(partitionCols);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionHashKey(MySqlParser.PartitionFunctionHashKeyContext ctx) {
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.HASH_KEY);
        this.partitionFunction.setFullColumnName(ctx.fullColumnName().getText());
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionRange(MySqlParser.PartitionFunctionRangeContext ctx) {
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.RANGE);
        if (ctx.expression() != null) {
            this.partitionFunction.setExpression(ctx.expression().getText());
        }
        SqlNodeList<SqlIdentifier> partitionCols = new SqlNodeList<SqlIdentifier>();
        if (ctx.uidList() != null) {
            ctx.uidList().uid().stream().forEach(uid -> partitionCols.addNode(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false)));
        }
        this.partitionFunction.setColumnName(partitionCols);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionList(MySqlParser.PartitionFunctionListContext ctx) {
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.LIST);
        if (ctx.expression() != null) {
            this.partitionFunction.setExpression(ctx.expression().getText());
        }
        SqlNodeList<SqlIdentifier> partitionCols = new SqlNodeList<SqlIdentifier>();
        if (ctx.uidList() != null) {
            ctx.uidList().uid().stream().forEach(uid -> partitionCols.addNode(new SqlIdentifier(QuoteUtils.removeQuote(uid.getText()), false)));
        }
        this.partitionFunction.setColumnName(partitionCols);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunctionValue(MySqlParser.PartitionFunctionValueContext ctx) {
        String fullColumn = ctx.fullColumnName().getText();
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.VALUE);
        if (ctx.LIFECYCLE() != null) {
            this.partitionFunction.setNumber(ctx.decimalLiteral().getText());
        }
        if (fullColumn.toUpperCase(Locale.ROOT).trim().startsWith(DATE_FROM_PREFIX)) {
            int columnEndIndex = fullColumn.indexOf(",", DATE_FROM_PREFIX.length());
            if (columnEndIndex <= 0) {
                return this.defaultResult();
            }
            this.partitionFunction.setFullColumnName(fullColumn.substring(DATE_FROM_PREFIX.length(), columnEndIndex));
            int stringLiteralStartIndex = fullColumn.indexOf("'", columnEndIndex);
            int stringLiteralEndIndex = fullColumn.indexOf("'", stringLiteralStartIndex + 1);
            if (stringLiteralStartIndex <= 0 || stringLiteralEndIndex <= 0) {
                return this.defaultResult();
            }
            this.partitionFunction.setStringLiteral(fullColumn.substring(stringLiteralStartIndex, stringLiteralEndIndex));
            this.partitionFunction.setDateFormat(true);
        } else {
            this.partitionFunction.setFullColumnName(fullColumn);
            if (ctx.DATE_FORMAT() != null) {
                this.partitionFunction.setDateFormat(true);
                this.partitionFunction.setStringLiteral(ctx.STRING_LITERAL().getText());
            }
        }
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionPeriod(MySqlParser.PartitionPeriodContext ctx) {
        this.partitionFunction.setFullColumnName(ctx.uid().getText());
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.PERIOD);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionFunctionDefinition visitPartitionFunction(MySqlParser.PartitionFunctionContext ctx) {
        MySqlParser.PartitionOptionFunctionContext partitionOptionFunctionContext = ctx.partitionOptionFunction();
        this.partitionFunction.setFullColumnName(partitionOptionFunctionContext.uid().getText());
        this.partitionFunction.setPartitionFunction(SqlPartitionFunctionDefinition.PartitionFunction.PERIOD);
        if (partitionOptionFunctionContext.RANGE_BUCKET() != null) {
            this.partitionFunction.setPartitionFunctionName("RANGE_BUCKET");
            RangeBucket rangeBucket = new RangeBucket();
            rangeBucket.setStartVal(partitionOptionFunctionContext.generateFunction().start.getText());
            rangeBucket.setEndVal(partitionOptionFunctionContext.generateFunction().end.getText());
            rangeBucket.setIntervalVal(partitionOptionFunctionContext.generateFunction().interval.getText());
            this.partitionFunction.setRangeBucket(rangeBucket);
        } else if (partitionOptionFunctionContext.DATE() != null) {
            this.partitionFunction.setPartitionFunctionName("DATE");
            this.partitionFunction.setPartitionInterval("day");
        } else {
            this.partitionFunction.setPartitionFunctionName(partitionOptionFunctionContext.truncFuncName.getText());
            this.partitionFunction.setPartitionInterval(partitionOptionFunctionContext.intervalType().getText());
        }
        return this.defaultResult();
    }
}

