/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;

public class PartitionOptionVisitor
extends AbstractVisitor<SqlPartitionOption> {
    private SqlPartitionOption partitionOption = new SqlPartitionOption();

    @Override
    protected SqlPartitionOption defaultResult() {
        return this.partitionOption;
    }

    @Override
    public SqlPartitionOption visitPartitionOptionEngine(MySqlParser.PartitionOptionEngineContext ctx) {
        if (ctx.STORAGE() != null) {
            this.partitionOption.setStorage(true);
            this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.STORAGE_ENGINE);
        } else {
            this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.ENGINE);
        }
        this.partitionOption.setEngineName(ctx.engineName().getText());
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionComment(MySqlParser.PartitionOptionCommentContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.COMMENT);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionDataDirectory(MySqlParser.PartitionOptionDataDirectoryContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.DATA_DIRECTORY);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionIndexDirectory(MySqlParser.PartitionOptionIndexDirectoryContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.INDEX_DIRECTORY);
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionMaxRows(MySqlParser.PartitionOptionMaxRowsContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.MAX_ROWS);
        this.partitionOption.setRowNums(new SqlLiteral(SqlTypeName.DECIMAL, ctx.maxRows.getText()));
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionMinRows(MySqlParser.PartitionOptionMinRowsContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.MIN_ROWS);
        this.partitionOption.setRowNums(new SqlLiteral(SqlTypeName.DECIMAL, ctx.minRows.getText()));
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionTablespace(MySqlParser.PartitionOptionTablespaceContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.TABLESPACE);
        this.partitionOption.setUid(new SqlIdentifier(ctx.uid().getText()));
        return this.defaultResult();
    }

    @Override
    public SqlPartitionOption visitPartitionOptionNodeGroup(MySqlParser.PartitionOptionNodeGroupContext ctx) {
        this.partitionOption.setPartitionOption(SqlPartitionOption.PartitionOption.NODEGROUP);
        this.partitionOption.setUid(new SqlIdentifier(ctx.uid().getText()));
        return this.defaultResult();
    }

    public static enum PartitionOptionEnum {
        ENGINE,
        STORAGE_ENGINE,
        COMMENT,
        DATA_DIRECTORY,
        INDEX_DIRECTORY,
        MAX_ROWS,
        MIN_ROWS,
        TABLESPACE,
        NODEGROUP;

    }
}

