/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionCallVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableStatementVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectColumnElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectExpressionElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectFunctionElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableElement;
import com.huawei.hwclouds.scs.sql.util.UidInKeyWord;
import org.antlr.v4.runtime.tree.ParseTree;

@ParseComment(value=CommentPosition.INLIST)
public class SelectElementVisitor
extends AbstractVisitor<SqlSelectElement> {
    private SqlSelectElement sqlSelectElement = new SqlSelectElement();

    @Override
    protected SqlSelectElement defaultResult() {
        return this.sqlSelectElement;
    }

    @Override
    public SqlSelectElement visitSelectStarElement(MySqlParser.SelectStarElementContext ctx) {
        this.sqlSelectElement.setFullId(UidInKeyWord.getUid(ctx.fullId().getText()));
        return this.defaultResult();
    }

    @Override
    public SqlSelectElement visitSelectSingleStarElement(MySqlParser.SelectSingleStarElementContext ctx) {
        if (ctx.STAR() != null) {
            this.sqlSelectElement.setIfHaveStar(true);
        }
        return this.defaultResult();
    }

    @Override
    public SqlSelectElement visitSelectColumnElement(MySqlParser.SelectColumnElementContext ctx) {
        SqlSelectColumnElement sqlSelectColumnElement = new SqlSelectColumnElement();
        sqlSelectColumnElement.setFullColumnName(UidInKeyWord.getUid(ctx.fullColumnName().getText()));
        sqlSelectColumnElement.setIfHaveAs(ctx.AS() != null);
        if (ctx.uid() != null) {
            sqlSelectColumnElement.setUid(UidInKeyWord.getUid(ctx.uid().getText(), "columnName"));
        }
        this.sqlSelectElement.setSqlSelectColumnElement(sqlSelectColumnElement);
        return this.defaultResult();
    }

    @Override
    public SqlSelectElement visitSelectFunctionElement(MySqlParser.SelectFunctionElementContext ctx) {
        SqlSelectFunctionElement sqlSelectFunctionElement = new SqlSelectFunctionElement();
        SqlFunctionCall sqlFunctionCall = (SqlFunctionCall)new FunctionCallVisitor().visit((ParseTree)ctx.functionCall());
        if (ctx.uid() != null) {
            sqlSelectFunctionElement.setUid(UidInKeyWord.getUid(ctx.uid().getText(), "columnName"));
            sqlSelectFunctionElement.setIfHaveAs(ctx.AS() != null);
        }
        sqlSelectFunctionElement.setSqlFunctionCall(sqlFunctionCall);
        this.sqlSelectElement.setSqlSelectFunctionElement(sqlSelectFunctionElement);
        return this.defaultResult();
    }

    @Override
    public SqlSelectElement visitSelectExpressionElement(MySqlParser.SelectExpressionElementContext ctx) {
        SqlSelectExpressionElement sqlSelectExpressionElement = new SqlSelectExpressionElement();
        ExpressionVisitor visitor = new ExpressionVisitor();
        SqlExpression sqlExpression = (SqlExpression)visitor.visit((ParseTree)ctx.expression());
        sqlSelectExpressionElement.setSqlExpression(sqlExpression);
        sqlSelectExpressionElement.setIfHaveAS(ctx.AS() != null);
        if (ctx.uid() != null) {
            sqlSelectExpressionElement.setUid(UidInKeyWord.getUid(ctx.uid().getText()));
        }
        this.sqlSelectElement.setSqlSelectExpressionElement(sqlSelectExpressionElement);
        return this.defaultResult();
    }

    @Override
    public SqlSelectElement visitTableStatement(MySqlParser.TableStatementContext ctx) {
        this.sqlSelectElement.setSqlTableElement((SqlTableElement)new TableStatementVisitor().visit((ParseTree)ctx));
        return this.defaultResult();
    }
}

