/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexColumnNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexOptionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ReferenceDefinitionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCheckTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlReference;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import org.antlr.v4.runtime.tree.ParseTree;

public class TableConstraintDeclarationVisitor
extends AbstractVisitor<SqlTableConstraint> {
    @Override
    protected SqlTableConstraint defaultResult() {
        return null;
    }

    @Override
    public SqlTableConstraint visitPrimaryKeyTableConstraint(MySqlParser.PrimaryKeyTableConstraintContext ctx) {
        SqlPKeyTableConstraint constraint = new SqlPKeyTableConstraint();
        if (ctx.name != null) {
            constraint.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.name.getText()), false));
        }
        if (ctx.indexType() != null) {
            constraint.setIndexType(ctx.indexType().BTREE() == null ? "HASH" : "BTREE");
        }
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            indexColumns.addNode(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(ctx.indexColumnNames().indexColumnName(i), true));
        }
        constraint.setIndexColumns(indexColumns);
        if (ctx.indexOption() != null && !ctx.indexOption().isEmpty()) {
            constraint.setOptions((SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)ctx));
        }
        return constraint;
    }

    @Override
    public SqlTableConstraint visitUniqueKeyTableConstraint(MySqlParser.UniqueKeyTableConstraintContext ctx) {
        SqlUKeyTableConstraint constraint = new SqlUKeyTableConstraint();
        if (ctx.name != null) {
            constraint.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.name.getText()), false));
        }
        if (ctx.indexFormat != null) {
            constraint.setIndexFormat(ctx.indexFormat.getText());
        }
        if (ctx.index != null) {
            constraint.setIndex(new SqlLiteral(SqlTypeName.VARCHAR, ctx.index.getText()));
        }
        if (ctx.indexType() != null) {
            constraint.setIndexType(ctx.indexType().BTREE() == null ? "HASH" : "BTREE");
        }
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            constraint.getIndexColumns().add(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(ctx.indexColumnNames().indexColumnName(i), true));
        }
        if (ctx.indexOption() != null && !ctx.indexOption().isEmpty()) {
            constraint.setOptions((SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)ctx));
        }
        return constraint;
    }

    @Override
    public SqlTableConstraint visitForeignKeyTableConstraint(MySqlParser.ForeignKeyTableConstraintContext ctx) {
        SqlFKeyTableConstraint constraint = new SqlFKeyTableConstraint();
        if (ctx.name != null) {
            constraint.setConstraint(new SqlLiteral(SqlTypeName.VARCHAR, ctx.name.getText()));
        }
        if (ctx.index != null) {
            constraint.setIndexName(new SqlLiteral(SqlTypeName.VARCHAR, ctx.index.getText()));
        }
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            constraint.getIndexColumns().add(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(ctx.indexColumnNames().indexColumnName(i), true));
        }
        constraint.setReference((SqlReference)new ReferenceDefinitionVisitor().visit((ParseTree)ctx));
        return constraint;
    }

    @Override
    public SqlTableConstraint visitCheckTableConstraint(MySqlParser.CheckTableConstraintContext ctx) {
        SqlCheckTableConstraint sqlCheckTableConstraint = new SqlCheckTableConstraint();
        if (ctx.uid() != null && ctx.uid().simpleId() != null) {
            sqlCheckTableConstraint.setSimpleId(ctx.uid().simpleId().getText());
        }
        SqlExpression sqlExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
        sqlCheckTableConstraint.setSqlExpression(sqlExpression);
        return sqlCheckTableConstraint;
    }
}

