/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexColumnNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexOptionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import org.antlr.v4.runtime.tree.ParseTree;

public class TableIndexDeclarationVisitor
extends AbstractVisitor<SqlCreateIndex> {
    private SqlTableName tableName;

    public TableIndexDeclarationVisitor(SqlTableName tableName) {
        this.tableName = tableName;
    }

    @Override
    protected SqlCreateIndex defaultResult() {
        return null;
    }

    @Override
    public SqlCreateIndex visitSimpleIndexDeclaration(MySqlParser.SimpleIndexDeclarationContext ctx) {
        SqlCreateIndex index = new SqlCreateIndex();
        index.setIndexFormat(ctx.indexFormat.getText());
        index.setTableName(this.tableName);
        MySqlParser.UidContext uc = ctx.uid();
        if (uc != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(uc.getText()), false));
        } else {
            String sb = this.createNewIndexName(ctx);
            index.setIndexName(new SqlIdentifier(sb, false));
        }
        if (ctx.indexType() != null) {
            index.setIndexType(ctx.indexType().BTREE() == null ? "HASH" : "BTREE");
        }
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            indexColumns.addNode((SqlIndexColumnName)((SqlNode)new IndexColumnNameVisitor().visit((ParseTree)ctx.indexColumnNames().indexColumnName(i))));
        }
        index.setIndexColumns(indexColumns);
        if (ctx.indexOption() != null && ctx.indexOption().size() != 0) {
            SqlIndexOptions indexOptions = (SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)ctx);
            index.setOptions(indexOptions);
        }
        return index;
    }

    @Override
    public SqlCreateIndex visitSpecialIndexDeclaration(MySqlParser.SpecialIndexDeclarationContext ctx) {
        SqlCreateIndex index = new SqlCreateIndex();
        if (ctx.FULLTEXT() != null) {
            index.setSpecialType(SqlCreateIndex.SpecialType.FULLTEXT);
        }
        if (ctx.SPATIAL() != null) {
            index.setSpecialType(SqlCreateIndex.SpecialType.SPATIAL);
        }
        if (ctx.indexFormat != null) {
            index.setIndexFormat(ctx.indexFormat.getText());
        }
        if (ctx.uid() != null) {
            index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
        }
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            indexColumns.addNode(new IndexColumnNameVisitor().visitIndexColumnNameIsConstraint(ctx.indexColumnNames().indexColumnName(i), true));
        }
        index.setIndexColumns(indexColumns);
        index.setTableName(this.tableName);
        if (ctx.indexOption() != null && ctx.indexOption().size() != 0) {
            SqlIndexOptions options = (SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)ctx);
            index.setOptions(options);
        }
        return index;
    }

    public String createNewIndexName(MySqlParser.SimpleIndexDeclarationContext ctx) {
        String str = this.tableName.getTableName().getIdentifier();
        StringBuilder indexNameBuffer = new StringBuilder();
        indexNameBuffer.append("IDX_" + str);
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            String name = ctx.indexColumnNames().indexColumnName(i).getText();
            if (name.indexOf("(") != -1) {
                name = name.substring(0, name.indexOf("("));
            }
            indexNameBuffer.append("_" + name);
        }
        String indexName = indexNameBuffer.toString();
        if (indexName.length() > 63) {
            indexName = indexName.substring(0, 63);
        }
        return indexName;
    }
}

