/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;

public class TableNameVisitor
extends AbstractVisitor<SqlTableName> {
    private SqlTableName context = new SqlTableName();

    @Override
    protected SqlTableName defaultResult() {
        return this.context;
    }

    @Override
    public SqlTableName visitFullId(MySqlParser.FullIdContext ctx) {
        if (ctx.uid() != null) {
            String fullName = QuoteUtils.removeQuote(ctx.uid().getText());
            String[] splitFullName = fullName.split("\\.");
            if (splitFullName.length == 3) {
                this.context.setDatabaseName(new SqlIdentifier(splitFullName[0], false));
                this.context.setSchemaName(new SqlIdentifier(splitFullName[1], false));
                this.context.setTableName(new SqlIdentifier(splitFullName[2], false));
            } else if (splitFullName.length == 2) {
                this.context.setDatabaseName(new SqlIdentifier(splitFullName[0], false));
                this.context.setTableName(new SqlIdentifier(splitFullName[1], false));
            } else {
                this.context.setTableName(new SqlIdentifier(fullName, false));
            }
        }
        if (ctx.scheOrDbName != null) {
            this.context.setDatabaseName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
            String tbName = ctx.scheOrDbName.getText().replace(".", "");
            this.context.setTableName(new SqlIdentifier(QuoteUtils.removeQuote(tbName), false));
        }
        if (ctx.tabName != null) {
            this.context.setDatabaseName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
            String schName = ctx.scheOrDbName.getText().replace(".", "");
            this.context.setSchemaName(new SqlIdentifier(QuoteUtils.removeQuote(schName), false));
            String tbName = ctx.tabName.getText().replace(".", "");
            this.context.setTableName(new SqlIdentifier(QuoteUtils.removeQuote(tbName), false));
        }
        return this.context;
    }
}

