/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DmlStatementVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableSourceVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexHint;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSource;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSourceItem;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableSources;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.UidInKeyWord;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;

@ParseComment
public class TableSourceItemVisitor
extends AbstractVisitor<SqlTableSourceItem> {
    private SqlTableSourceItem sqlTableSourceItem = new SqlTableSourceItem();

    @Override
    protected SqlTableSourceItem defaultResult() {
        return this.sqlTableSourceItem;
    }

    @Override
    public SqlTableSourceItem visitAtomTableItem(MySqlParser.AtomTableItemContext ctx) {
        int i;
        this.sqlTableSourceItem.setTableName(ctx.tableName().getText());
        if (ctx.uidList() != null) {
            LinkedList<String> partitionUidList = new LinkedList<String>();
            for (i = 0; i < ctx.uidList().uid().size(); ++i) {
                partitionUidList.add(QuoteUtils.addDoubleQuoteAndToLowerCase(ctx.uidList().uid(i).getText()));
            }
            this.sqlTableSourceItem.setPartitionUidList(partitionUidList);
        }
        if (ctx.uid() != null) {
            this.sqlTableSourceItem.setUid(UidInKeyWord.getUid(ctx.uid().getText()));
            if (ctx.AS() != null) {
                this.sqlTableSourceItem.setIfHaveAs(true);
            }
        }
        if (ctx.indexHint() != null) {
            SqlNodeList<SqlIndexHint> sqlIndexHintSqlNodeList = new SqlNodeList<SqlIndexHint>();
            for (i = 0; i < ctx.indexHint().size(); ++i) {
                SqlIndexHint sqlIndexHint = new SqlIndexHint();
                sqlIndexHint.setIndexHintAction(ctx.indexHint((int)i).indexHintAction.getText());
                sqlIndexHint.setKeyFormat(ctx.indexHint((int)i).keyFormat.getText());
                if (ctx.indexHint(i).indexHintType() != null) {
                    sqlIndexHint.setIndexHintType(ctx.indexHint(i).indexHintType().getText());
                }
                LinkedList<String> indexHintUidList = new LinkedList<String>();
                for (int j = 0; j < ctx.indexHint(i).uidList().uid().size(); ++j) {
                    indexHintUidList.set(j, ctx.indexHint(i).uidList().uid(j).getText());
                }
                sqlIndexHint.setUidList(indexHintUidList);
                sqlIndexHintSqlNodeList.addNode(sqlIndexHint);
            }
        }
        return this.defaultResult();
    }

    @Override
    public SqlTableSourceItem visitSubqueryTableItem(MySqlParser.SubqueryTableItemContext ctx) {
        DmlStatementVisitor visitor = new DmlStatementVisitor();
        if (ctx.LR_BRACKET() != null && ctx.RR_BRACKET() != null) {
            this.sqlTableSourceItem.setBrackets(true);
        }
        SqlSelectStatement sqlSelectStatement = (SqlSelectStatement)visitor.visit((ParseTree)ctx.selectStatement());
        this.sqlTableSourceItem.setSqlSelectStatement(sqlSelectStatement);
        this.sqlTableSourceItem.setIfHaveAs(ctx.AS() != null);
        if (ctx.uid() != null) {
            this.sqlTableSourceItem.setUid(UidInKeyWord.getUid(ctx.uid().getText()));
        }
        return this.defaultResult();
    }

    @Override
    public SqlTableSourceItem visitTableSourcesItem(MySqlParser.TableSourcesItemContext ctx) {
        SqlTableSources sqlTableSources = new SqlTableSources();
        SqlNodeList<SqlTableSource> sqlTableSourceSqlNodeList = new SqlNodeList<SqlTableSource>();
        for (int i = 0; i < ctx.tableSources().tableSource().size(); ++i) {
            TableSourceVisitor tableSourceVisitor = new TableSourceVisitor();
            SqlTableSource sqlTableSource = (SqlTableSource)tableSourceVisitor.visit((ParseTree)ctx.tableSources().tableSource(i));
            sqlTableSourceSqlNodeList.addNode(sqlTableSource);
        }
        sqlTableSources.setSqlTableSource(sqlTableSourceSqlNodeList);
        this.sqlTableSourceItem.setTableSources(sqlTableSources);
        return this.defaultResult();
    }
}

