/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql;

import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlRoot;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

public interface UnParser<T extends SqlNode> {
    public void unparse(T var1, SqlWriter var2, UnParserContext var3);

    default public void unparseWithComment(T sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode instanceof SqlRoot) {
            boolean isContainAlterStatementNode = false;
            for (SqlNode sqlNode1 : ((SqlRoot)sqlNode).getNodes()) {
                if (!(sqlNode1 instanceof SqlAlterTable)) continue;
                isContainAlterStatementNode = true;
            }
            if (isContainAlterStatementNode) {
                this.unparseComment((SqlCommentNode)sqlNode, writer);
                this.unparse(sqlNode, writer, context);
                return;
            }
            this.unparse(sqlNode, writer, context);
            this.unparseComment((SqlRoot)sqlNode, writer);
        } else if (sqlNode instanceof SqlCommentNode) {
            SqlCommentNode sqlCommentNode = (SqlCommentNode)sqlNode;
            if (sqlCommentNode.getCommentPosition() == null || sqlCommentNode.getCommentPosition() == CommentPosition.PRE) {
                this.unparseComment((SqlCommentNode)sqlNode, writer);
            }
            this.unparse(sqlNode, writer, context);
            if (sqlCommentNode.getCommentPosition() == CommentPosition.POST) {
                this.unparseComment((SqlCommentNode)sqlNode, writer);
            }
        } else {
            this.unparse(sqlNode, writer, context);
        }
    }

    default public void unparseComment(SqlCommentNode comments, SqlWriter writer) {
        if (comments.getComments() == null || comments.getComments().isEmpty()) {
            return;
        }
        comments.getComments().stream().map(stream -> {
            if (stream.trim().startsWith("#")) {
                StringBuilder sb = new StringBuilder("--");
                int hashtagStart = 0;
                int hashtagEnd = 0;
                char[] cs = stream.toCharArray();
                for (int index = 0; index < cs.length; ++index) {
                    if (cs[index] == '#') {
                        if (hashtagStart == 0) {
                            hashtagStart = index;
                        }
                        if (hashtagStart == 0 || hashtagEnd == 0) continue;
                        sb.append(cs[index]);
                        continue;
                    }
                    if (hashtagStart != 0 && hashtagEnd == 0) {
                        hashtagEnd = index;
                    }
                    sb.append(cs[index]);
                }
                return sb.toString();
            }
            return stream;
        }).forEach(s -> writer.append((String)s));
    }
}

