/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql;

import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.StructInfo;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class UnParserContext {
    private static final String DEFAULT_NODE_LIST_SEPARATOR = ",";
    private Stack<Class<? extends SqlNode>> parserStack = new Stack();
    private Stack<String> nodeListSeparatorStack = new Stack();
    private Stack<Boolean> nodeListTransactionStack = new Stack();
    private SqlTableName currentTableName;
    public boolean oriSchema = false;
    public boolean deleteCase = false;
    public boolean haveJoinPartCase = false;
    public List<StructInfo> structInfoList = new ArrayList<StructInfo>();
    public SqlIdentifier columnNameForStructType = null;
    public boolean jsonCase = false;
    public boolean jsonSetCase = false;
    public boolean jsonUnquoteCase = false;
    private boolean existArrayOrStruct = false;

    public void enterCurrentParser(SqlNode node) {
        this.parserStack.push(node.getClass());
    }

    public Class<? extends SqlNode> exitCurrentParser() {
        if (!this.parserStack.isEmpty()) {
            return this.parserStack.pop();
        }
        return null;
    }

    public Class<? extends SqlNode> getCurrentParser() {
        if (this.parserStack.isEmpty()) {
            return null;
        }
        return this.parserStack.peek();
    }

    public String getNodeListSeparatorOrDefault() {
        return this.nodeListSeparatorStack == null || this.nodeListSeparatorStack.isEmpty() ? DEFAULT_NODE_LIST_SEPARATOR : this.nodeListSeparatorStack.peek();
    }

    public void setNodeListSeparator(String nodeListSeparatorStack) {
        this.nodeListSeparatorStack.push(nodeListSeparatorStack);
    }

    public void resetNodeListSeparator() {
        this.nodeListSeparatorStack.pop();
    }

    public boolean getNodeListTransactionOrDefault() {
        return this.nodeListTransactionStack == null || this.nodeListTransactionStack.isEmpty() ? false : this.nodeListTransactionStack.peek();
    }

    public void setNodeListTransaction(boolean enable) {
        this.nodeListTransactionStack.push(enable);
    }

    public void resetNodeListTransaction() {
        this.nodeListTransactionStack.pop();
    }

    public SqlTableName getCurrentTableName() {
        return this.currentTableName;
    }

    public void setCurrentTableName(SqlTableName currentTableName) {
        this.currentTableName = currentTableName;
    }

    public boolean isOriSchema() {
        return this.oriSchema;
    }

    public void setOriSchema(boolean oriSchema) {
        this.oriSchema = oriSchema;
    }

    public boolean isDeleteCase() {
        return this.deleteCase;
    }

    public void setDeleteCase(boolean deleteCase) {
        this.deleteCase = deleteCase;
    }

    public boolean isHaveJoinPartCase() {
        return this.haveJoinPartCase;
    }

    public void setHaveJoinPartCase(boolean haveJoinPartCase) {
        this.haveJoinPartCase = haveJoinPartCase;
    }

    public List<StructInfo> getStructInfoList() {
        return this.structInfoList;
    }

    public void setStructInfoList(List<StructInfo> structInfoList) {
        this.structInfoList = structInfoList;
    }

    public SqlIdentifier getColumnNameForStructType() {
        return this.columnNameForStructType;
    }

    public void setColumnNameForStructType(SqlIdentifier columnNameForStructType) {
        this.columnNameForStructType = columnNameForStructType;
    }

    public boolean isJsonCase() {
        return this.jsonCase;
    }

    public void setJsonCase(boolean jsonCase) {
        this.jsonCase = jsonCase;
    }

    public boolean isJsonSetCase() {
        return this.jsonSetCase;
    }

    public void setJsonSetCase(boolean jsonSetCase) {
        this.jsonSetCase = jsonSetCase;
    }

    public boolean isJsonUnquoteCase() {
        return this.jsonUnquoteCase;
    }

    public void setJsonUnquoteCase(boolean jsonUnquoteCase) {
        this.jsonUnquoteCase = jsonUnquoteCase;
    }

    public boolean isExistArrayOrStruct() {
        return this.existArrayOrStruct;
    }

    public void setExistArrayOrStruct(boolean existArrayOrStruct) {
        this.existArrayOrStruct = existArrayOrStruct;
    }

    public String getConfigValue(SqlWriter writer, String key, String defaultValue) {
        ConvertConfig config;
        String tableName = null;
        if (this.getCurrentTableName() != null) {
            tableName = this.getCurrentTableName().getTableName().getIdentifier();
        }
        if ((config = writer.getConfig(tableName)) == null) {
            return null;
        }
        return config.getStringValue(key, defaultValue);
    }

    public void clear() {
        this.currentTableName = null;
    }
}

