/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.cli;

import com.huawei.hwclouds.scs.sql.cli.CliOptions;
import com.huawei.hwclouds.scs.sql.util.CommonUtils;
import com.huawei.hwclouds.scs.sql.util.ParserException;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CliParser {
    private static final Logger LOGGER = LogManager.getLogger(CliParser.class);
    private static final String PARSER_ERROR_MSG = "Failed to parse arguments";

    public CliOptions parser(String[] args) throws ParserException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.getCliOptions(), args, true);
        }
        catch (ParseException e) {
            LOGGER.info("Failed to parse arguments. message: {}", (Object)e.getMessage());
            LOGGER.error("Failed to parse arguments.", (Throwable)e);
        }
        if (cmd == null || cmd.getOptions() == null || cmd.getOptions().length == 0 || cmd.hasOption("H")) {
            this.printHelp();
            return null;
        }
        CliOptions options = new CliOptions();
        if (cmd.hasOption("V")) {
            LOGGER.info("Version: GaussDB Tools DSC v2.0.0");
            return null;
        }
        this.checkDialect(cmd, options);
        this.checkInputFolder(cmd, options);
        CliParser.checkOutputFolder(cmd, options);
        return options;
    }

    private static void checkOutputFolder(CommandLine cmd, CliOptions options) throws ParserException {
        if (!cmd.hasOption("O")) {
            LOGGER.error("output-folder can not be null.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        String outputFolder = cmd.getOptionValue("O");
        File fOutputFolder = new File(outputFolder);
        if (!CommonUtils.createNewFile(outputFolder, false)) {
            LOGGER.error("Cannot create file " + outputFolder);
            throw new ParserException("Cannot create file " + outputFolder);
        }
        if (CliParser.checkArguments(!fOutputFolder.isDirectory(), "output-folder is not a directory.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (CliParser.checkArguments(!fOutputFolder.canWrite(), "no write permissions for output folder.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setOutputFolder(outputFolder);
    }

    private void checkInputFolder(CommandLine cmd, CliOptions options) throws ParserException {
        if (!cmd.hasOption("I")) {
            LOGGER.error("input-folder can not be null.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        String inputFolder = cmd.getOptionValue("I");
        File fInputFolder = new File(inputFolder);
        if (CliParser.checkArguments(!fInputFolder.exists(), "input-folder does not exists.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        try {
            String canonicalInputPath = fInputFolder.getCanonicalPath();
            LOGGER.debug("canonical input path : ", (Object)canonicalInputPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to get canonicalPath " + fInputFolder, (Throwable)e);
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (CliParser.checkArguments(!fInputFolder.isDirectory(), "input-folder is not a directory.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (CliParser.checkArguments(!fInputFolder.canRead(), "input-folder can not be read.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setInputFolder(inputFolder);
    }

    private void checkDialect(CommandLine cmd, CliOptions options) throws ParserException {
        if (!cmd.hasOption("S")) {
            LOGGER.error("source-db can not be null.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        String sourceDataBase = cmd.getOptionValue("S");
        SqlDialect dialect = SqlDialect.getDialect(sourceDataBase);
        if (CliParser.checkArguments(dialect == null, "invalid source db.")) {
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setSourceDialect(dialect);
    }

    private static boolean checkArguments(boolean condition, String errorMessage) {
        if (!condition) {
            return false;
        }
        LOGGER.error(errorMessage);
        return true;
    }

    private Options getCliOptions() {
        Options options = new Options();
        options.addOption("S", "source-db", true, "The source database, which can be either MySQL");
        options.addOption("I", "input-folder", true, "The input/source folder that contains the Teradata/Oracle scripts to be migrated.");
        options.addOption("O", "output-folder", true, "The output/target folder where the migrated scripts are placed.");
        options.addOption("A", "application-lang", false, "The application language type, which can be either SQL or Perl. Default it SQL. It was a Compatibility parameter in schema convert tool.");
        options.addOption("M", "conversion-type", false, "The conversion type, which can be either Bulk or BLogic. It was a Compatibility parameter in schema convert tool.");
        options.addOption("L", "log-folder", false, "The log file path where the log files are created. It was a Compatibility parameter in schema convert tool, the log folder can be changed in log4j2_mysql.xml.");
        options.addOption("V", "version", false, "Version of DSC");
        options.addOption("H", "help", false, "Lists for help");
        return options;
    }

    private void printHelp() {
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(120);
        hf.printHelp("H", this.getCliOptions());
    }
}

