/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.nodes;

import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

public class SqlCreateIndex
extends SqlCommentNode {
    private String indexFormat;
    private SqlIdentifier indexName;
    private SpecialType specialType;
    private String indexType;
    private SqlTableName tableName;
    private SqlNodeList<SqlIndexColumnName> indexColumns;
    private SqlIndexOptions options;

    public SqlIdentifier getConstructedIndexName(SqlWriter writer, UnParserContext context) {
        SqlWriter nWriter = writer.cloneEmpty();
        this.getTableName().unparse(nWriter, context);
        String fullTName = nWriter.toSqlString().getSql();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        String idxColumns = QuoteUtils.removeDoubleQuote(this.constructIdxColumnStr(this, nWriter, context));
        String idxName = idxPrefix + tName + "_" + idxColumns;
        if (idxName.length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return new SqlIdentifier(idxName, false);
    }

    private String constructIdxColumnStr(SqlCreateIndex sqlCreateIndex, SqlWriter writer, UnParserContext context) {
        context.setNodeListSeparator("_");
        SqlWriter cWriter = writer.cloneEmpty();
        sqlCreateIndex.getIndexColumns().unparse(cWriter, context);
        context.resetNodeListSeparator();
        return cWriter.toSqlString().getSql();
    }

    public void setIndexFormat(String indexFormat) {
        this.indexFormat = indexFormat;
    }

    public void setIndexName(SqlIdentifier indexName) {
        this.indexName = indexName;
    }

    public void setSpecialType(SpecialType specialType) {
        this.specialType = specialType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void setTableName(SqlTableName tableName) {
        this.tableName = tableName;
    }

    public void setIndexColumns(SqlNodeList<SqlIndexColumnName> indexColumns) {
        this.indexColumns = indexColumns;
    }

    public void setOptions(SqlIndexOptions options) {
        this.options = options;
    }

    public String getIndexFormat() {
        return this.indexFormat;
    }

    public SqlIdentifier getIndexName() {
        return this.indexName;
    }

    public SpecialType getSpecialType() {
        return this.specialType;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public SqlTableName getTableName() {
        return this.tableName;
    }

    public SqlNodeList<SqlIndexColumnName> getIndexColumns() {
        return this.indexColumns;
    }

    public SqlIndexOptions getOptions() {
        return this.options;
    }

    public static enum SpecialType {
        NORMAL,
        PRIMARY,
        UNIQUE,
        FULLTEXT,
        SPATIAL;

    }
}

