/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.util;

import com.huawei.db.migration.util.SetFilePermission;
import com.huawei.hwclouds.scs.sql.util.ParserException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonUtils {
    public static final int MAX_LENGTH_INDEX_NAME = 63;
    private static final Logger LOGGER = LogManager.getLogger(CommonUtils.class);

    public static boolean createNewFile(String fileName, boolean forceOverWrite) throws ParserException {
        try {
            Path path = Paths.get(fileName, new String[0]);
            SetFilePermission filePer = new SetFilePermission();
            boolean isFileCreated = false;
            if (!forceOverWrite && path.toFile().exists()) {
                return true;
            }
            LOGGER.info("Trying to create file {}", (Object)path.toString());
            String osName = System.getProperty("os.name");
            isFileCreated = osName != null && osName.toLowerCase(Locale.ROOT).contains("win") ? filePer.createFileWithPermissionInWin(path.toString()) : filePer.createFileWithPermissionInLinux(path.toString());
            if (!isFileCreated) {
                LOGGER.error(path.toString() + " Target File is already created / failed to create");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error in creating file. " + e.toString());
            throw new ParserException("File creation error");
        }
    }
}

