/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.writer;

import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.util.SqlString;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlPrettyWriter
implements SqlWriter {
    private static final Logger LOGGER = LogManager.getLogger(SqlPrettyWriter.class);
    private static final int INDENTATION_SPACE_SIZE = 2;
    private SqlDialect dialect;
    private int indentationLevel = 0;
    private StringWriter sw = new StringWriter();
    private ConvertConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs;

    public SqlPrettyWriter(SqlDialect dialect, ConvertConfig defaultConfig, Map<String, ConvertConfig> tableConfigs) {
        this.dialect = dialect;
        this.defaultConfig = defaultConfig;
        this.tableConfigs = tableConfigs;
    }

    @Override
    public SqlWriter append(String sql) {
        if (sql == null || sql.isEmpty()) {
            return this;
        }
        this.sw.append(sql);
        return this;
    }

    @Override
    public SqlWriter append(SqlWriter writer) {
        this.sw.append(writer.toSqlString().getSql());
        return this;
    }

    @Override
    public SqlWriter writeSpace(int size) {
        for (int i = 0; i < size; ++i) {
            this.sw.append(" ");
        }
        return this;
    }

    @Override
    public SqlWriter writeSpace() {
        this.sw.append(" ");
        return this;
    }

    @Override
    public SqlWriter indentation(int level) {
        for (int i = 0; i < level; ++i) {
            this.writeSpace(2);
        }
        return this;
    }

    @Override
    public SqlWriter newLine() {
        this.sw.append(System.lineSeparator());
        return this;
    }

    @Override
    public SqlWriter sqlEnd() {
        this.sw.append(";");
        return this;
    }

    @Override
    public SqlString toSqlString() {
        return new SqlString(this.dialect, this.sw.toString());
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @Override
    public SqlWriter cloneEmpty() {
        return new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
    }

    @Override
    public ConvertConfig getConfig(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            return this.defaultConfig;
        }
        String formattedTableName = tableName.toUpperCase(Locale.US);
        return this.tableConfigs.containsKey(formattedTableName) ? this.tableConfigs.get(formattedTableName) : this.defaultConfig;
    }
}

