/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.clu;

import com.huawei.db.migration.clu.GaussDBVerificationUtility;
import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.services.MigrationService;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.SetFilePermission;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CLMigrationUtility {
    private static final Logger logger = LogManager.getLogger(CLMigrationUtility.class);
    private static String osName = System.getProperty("os.name");
    private static String sourceDb = null;
    private static String preExecutionPath = null;
    private static String version = "v2.0.0";

    private static void displayVersionHelp(String[] args) {
        if ("--version".equalsIgnoreCase(args[0]) || "-V".equalsIgnoreCase(args[0])) {
            QueryConversionUtility.printConsoleMessage("Version: GaussDB Tools DSC " + version);
        } else if ("--help".equalsIgnoreCase(args[0]) || "-H".equalsIgnoreCase(args[0])) {
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("To migrate source database scripts to FusionInsight LibrA");
            CLMigrationUtility.printMsgForSrcTgtIO();
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("    -M | --conversion-type");
            QueryConversionUtility.printConsoleMessage("    The conversion type, which can be either DDL or PLSQL.");
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("    -L | --log-folder");
            QueryConversionUtility.printConsoleMessage("    The log file path where the log files are created.");
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("    -VN | --version-number");
            QueryConversionUtility.printConsoleMessage("    The version number, which can be either V1R7 or V1R8_330.");
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("To display DSC version details");
            QueryConversionUtility.printConsoleMessage("sh dsc.sh -V | --version");
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("To display DSC help details");
            QueryConversionUtility.printConsoleMessage("sh dsc.sh -H | --help");
            QueryConversionUtility.printConsoleMessage("");
            QueryConversionUtility.printConsoleMessage("Refer the user manual for more details.");
            QueryConversionUtility.printConsoleMessage("");
        } else {
            QueryConversionUtility.printConsoleMessage("Please enter valid Input parameters, Kindly refer the user manual to execute.");
        }
    }

    private static void printMsgForSrcTgtIO() {
        QueryConversionUtility.printConsoleMessage("java -jar dsctool.jar -S <source-database> [-T <target-database>] -I <input-script-path> -O <output-script-path> [-M <conversion-type>] [-L <log-path>] [-VN <version-number>]");
        QueryConversionUtility.printConsoleMessage("");
        QueryConversionUtility.printConsoleMessage("    -S | --source-db");
        QueryConversionUtility.printConsoleMessage("    The source database, which can be either Teradata or Oracle or Netezza or DB2.");
        QueryConversionUtility.printConsoleMessage("");
        QueryConversionUtility.printConsoleMessage("    -T | --target-db");
        QueryConversionUtility.printConsoleMessage("    The target database, which can be either gaussdbt or gaussdba. DSC Tool assumes GaussDBA as default target database.");
        QueryConversionUtility.printConsoleMessage("");
        QueryConversionUtility.printConsoleMessage("    -I | --input-folder");
        QueryConversionUtility.printConsoleMessage("    The input/source folder that contains the Teradata/Oracle/Netezza/DB2 scripts to be migrated.");
        QueryConversionUtility.printConsoleMessage("");
        QueryConversionUtility.printConsoleMessage("    -O | --output-folder");
        QueryConversionUtility.printConsoleMessage("    The output/target folder where the migrated scripts are placed.");
    }

    public static void main(String[] args) {
        CLMigrationUtility.main(args, null, null);
    }

    public static void main(String[] args, HashMap<String, String> featureProp) {
        CLMigrationUtility.main(args, featureProp, null);
    }

    public static void main(String[] args, HashMap<String, String> featureProp, HashMap<String, String> applicationProp) {
        if (args.length == 4 || args.length == 5 || args.length == 6) {
            sourceDb = args[2];
            String targetDb = "";
            if (args.length >= 5) {
                targetDb = args[4];
            }
            if (args.length == 6) {
                preExecutionPath = args[5];
            }
            try {
                CLMigrationUtility.configValAndMigrate(args, featureProp, applicationProp, targetDb);
            }
            catch (MigrationServiceException e) {
                logger.error(e.getMessage());
                logger.error("[DSC_ERR_004_034] " + MessageLoader.getMessage("DSC_ERR_004_034"));
                QueryConversionUtility.printConsoleMessage("DSC Application failed to start : " + e.getMessage());
            }
            catch (FileException e) {
                logger.error("[DSC_ERR_004_034] FileException: " + ErrorLoggerUtility.getExceptionDetails(e) + " " + MessageLoader.getMessage("DSC_ERR_004_034"));
                QueryConversionUtility.printConsoleMessage("DSC Application failed to start with FileException.");
            }
        } else if (args.length == 1) {
            CLMigrationUtility.displayVersionHelp(args);
        } else {
            CLMigrationUtility.printErrorMsg();
        }
    }

    private static void configValAndMigrate(String[] args, HashMap<String, String> featureProp, HashMap<String, String> applicationProp, String targetDb) {
        logger.info("DSC is initiated by {}", (Object)System.getProperty("user.name"));
        CLMigrationUtility.setLogFilePermission();
        long start = System.currentTimeMillis();
        CLMigrationUtility.setPermissionsForConfigFiles();
        ApplicationPropertyLoader.loadProperty("application");
        MessageLoader.loadMessages();
        String dbType = targetDb;
        boolean executevalue = ApplicationProperty.getBooleanProperty("executesqlingauss");
        String applicationlang = System.getProperty("APPLICATION_LANG");
        String gaussDbPass = null;
        if (!"perl".equals(applicationlang) && executevalue) {
            gaussDbPass = GaussDBVerificationUtility.getPassword("Enter GaussDB Password: ");
            if (dbType.isEmpty()) {
                dbType = "gaussDBA";
            }
            dbType = QueryConversionUtility.toLower(dbType);
            GaussDBVerificationUtility.configValidation(gaussDbPass, dbType, preExecutionPath);
        }
        QueryConversionUtility.printConsoleMessage("\n********************** Schema Conversion Started *************************\n");
        String[] sourceTargetDb = new String[]{sourceDb, targetDb};
        MigrationService.setProperties(featureProp, applicationProp);
        String sourceDir = args[0];
        String targetDir = args[1];
        String migrationType = args[3];
        MigrationService.doMigrate(sourceTargetDb, migrationType, sourceDir, targetDir);
        long end = System.currentTimeMillis();
        CLMigrationUtility.printConsoleAndLogger();
        CLMigrationUtility.printConsoleLogger(end - start);
        GaussDBVerificationUtility.executeVerificationCmd(targetDir, migrationType, dbType, executevalue, applicationlang, gaussDbPass);
    }

    private static void printErrorMsg() {
        QueryConversionUtility.printConsoleMessage("The number of input arguments to the application is not expected.");
        QueryConversionUtility.printConsoleMessage("Please validate it and try again");
    }

    private static void printConsoleLogger(long diff) {
        String millisecs = " seconds";
        long diffSec = diff / 1000L;
        QueryConversionUtility.printConsoleMessage("DSC total process time : " + diffSec + millisecs);
        logger.info(MessageLoader.getMessage("processTime"), (Object)diffSec, (Object)millisecs);
        QueryConversionUtility.printConsoleMessage("\n********************* Schema Conversion Completed ************************\n\n");
    }

    private static void printConsoleAndLogger() {
        String logPath = System.getProperty("LOGFILE_PATH");
        QueryConversionUtility.printConsoleMessage("Log file path : " + logPath + System.getProperty("file.separator") + "dsc.log");
        logger.info(MessageLoader.getMessage("logLocn"), (Object)logPath);
        if (ErrorLoggerUtility.totalFailedFiles() > 0) {
            QueryConversionUtility.printConsoleMessage("Error Log file path : " + logPath + System.getProperty("file.separator") + "dscError.log");
            logger.info(MessageLoader.getMessage("errorLogLocn"), (Object)logPath);
        }
        QueryConversionUtility.printConsoleMessage("DSC process end time : " + new Date());
        logger.info(MessageLoader.getMessage("migrationCompletedTime"), (Object)new Date().toString());
    }

    private static void setPermissionsForConfigFiles() {
        SetFilePermission filePer = new SetFilePermission();
        String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
        if (configDir != null) {
            if (QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win")) {
                if (filePer.changeFilePermissionInWin(configDir)) {
                    logger.info("Successfully changed permission of files in {}", (Object)configDir);
                } else {
                    logger.info("Failed to change permission of files in {}", (Object)configDir);
                }
            } else if (filePer.changeFilePermissionInLinux(configDir)) {
                logger.info("Successfully changed permission of files in {}", (Object)configDir);
            } else {
                logger.info("Failed to change permission of files in {}", (Object)configDir);
            }
        }
    }

    private static void setLogFilePermission() throws FileException {
        SetFilePermission filePer = new SetFilePermission();
        String logfolder = System.getProperty("LOGFILE_PATH");
        try {
            if (osName.toLowerCase(Locale.ROOT).contains("win")) {
                filePer.changeFilePermissionInWin(logfolder);
            } else {
                filePer.changeFilePermissionInLinux(logfolder);
            }
        }
        catch (FileException e) {
            throw new FileException("[DSC_ERR_005_027] " + MessageLoader.getMessage("DSC_ERR_005_027"));
        }
    }
}

